/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.runtime.impl;

import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.security.auth.Subject;
import javax.xml.transform.Source;
import org.apache.servicemix.nmr.api.Message;

public class NormalizedMessageImpl
implements NormalizedMessage {
    private Message message;

    public NormalizedMessageImpl(Message message) {
        assert (message != null) : "Encapsulated message should never be null!";
        this.message = message;
    }

    public Message getInternalMessage() {
        return this.message;
    }

    public void addAttachment(String id, DataHandler content) throws MessagingException {
        this.message.addAttachment(id, (Object)content);
    }

    public Source getContent() {
        return (Source)this.message.getBody(Source.class);
    }

    public DataHandler getAttachment(String id) {
        Object attachment = this.message.getAttachment(id);
        if (attachment == null || attachment instanceof DataHandler) {
            return (DataHandler)attachment;
        }
        DataHandler dh = new DataHandler(attachment, null);
        return dh;
    }

    public Set getAttachmentNames() {
        return this.message.getAttachments().keySet();
    }

    public void removeAttachment(String id) throws MessagingException {
        this.message.removeAttachment(id);
    }

    public void setContent(Source content) throws MessagingException {
        this.message.setBody((Object)content);
    }

    public void setProperty(String name, Object value) {
        this.message.setHeader(name, value);
    }

    public void setSecuritySubject(Subject subject) {
        this.message.setSecuritySubject(subject);
    }

    public Set getPropertyNames() {
        return this.message.getHeaders().keySet();
    }

    public Object getProperty(String name) {
        return this.message.getHeader(name);
    }

    public Subject getSecuritySubject() {
        return this.message.getSecuritySubject();
    }
}

