/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl;

import java.io.StringReader;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionImpl;
import org.apache.commons.jexl.parser.ASTExpressionExpression;
import org.apache.commons.jexl.parser.ASTForeachStatement;
import org.apache.commons.jexl.parser.ASTIfStatement;
import org.apache.commons.jexl.parser.ASTReferenceExpression;
import org.apache.commons.jexl.parser.ASTStatementExpression;
import org.apache.commons.jexl.parser.ASTWhileStatement;
import org.apache.commons.jexl.parser.ParseException;
import org.apache.commons.jexl.parser.Parser;
import org.apache.commons.jexl.parser.SimpleNode;
import org.apache.commons.jexl.parser.TokenMgrError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExpressionFactory {
    protected static Log log = LogFactory.getLog((String)"org.apache.commons.jexl.ExpressionFactory");
    protected static Parser parser = new Parser(new StringReader(";"));
    protected static ExpressionFactory ef = new ExpressionFactory();

    private ExpressionFactory() {
    }

    protected static ExpressionFactory getInstance() {
        return ef;
    }

    public static Expression createExpression(String expression) throws Exception {
        return ExpressionFactory.getInstance().createNewExpression(expression);
    }

    protected Expression createNewExpression(String expression) throws Exception {
        SimpleNode node;
        SimpleNode tree;
        String expr = this.cleanExpression(expression);
        Parser parser = ExpressionFactory.parser;
        synchronized (parser) {
            log.debug((Object)("Parsing expression: " + expr));
            try {
                tree = ExpressionFactory.parser.parse(new StringReader(expr));
            }
            catch (TokenMgrError tme) {
                throw new ParseException(tme.getMessage());
            }
        }
        if (tree.jjtGetNumChildren() > 1 && log.isWarnEnabled()) {
            log.warn((Object)("The JEXL Expression created will be a reference to the first expression from the supplied script: \"" + expression + "\" "));
        }
        if ((node = (SimpleNode)tree.jjtGetChild(0)) instanceof ASTReferenceExpression || node instanceof ASTExpressionExpression || node instanceof ASTStatementExpression || node instanceof ASTIfStatement || node instanceof ASTWhileStatement || node instanceof ASTForeachStatement) {
            return new ExpressionImpl(expression, node);
        }
        log.error((Object)("Invalid Expression, node of type: " + node.getClass().getName()));
        throw new Exception("Invalid Expression: not a Reference, Expression, Statement or If");
    }

    private String cleanExpression(String expression) {
        String expr = expression.trim();
        if (!expr.endsWith(";")) {
            expr = expr + ";";
        }
        return expr;
    }
}

