/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.ansi;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class Code {
    public static final int OFF = 0;
    public static final int BOLD = 1;
    public static final int UNDERSCORE = 4;
    public static final int BLINK = 5;
    public static final int REVERSE = 7;
    public static final int CONCEALED = 8;
    public static final int FG_BLACK = 30;
    public static final int FG_RED = 31;
    public static final int FG_GREEN = 32;
    public static final int FG_YELLOW = 33;
    public static final int FG_BLUE = 34;
    public static final int FG_MAGENTA = 35;
    public static final int FG_CYAN = 36;
    public static final int FG_WHITE = 37;
    public static final int BLACK = 30;
    public static final int RED = 31;
    public static final int GREEN = 32;
    public static final int YELLOW = 33;
    public static final int BLUE = 34;
    public static final int MAGENTA = 35;
    public static final int CYAN = 36;
    public static final int WHITE = 37;
    public static final int BG_BLACK = 40;
    public static final int BG_RED = 41;
    public static final int BG_GREEN = 42;
    public static final int BG_YELLOW = 43;
    public static final int BG_BLUE = 44;
    public static final int BG_MAGENTA = 45;
    public static final int BG_CYAN = 46;
    public static final int BG_WHITE = 47;
    private static final char ESC = '\u001b';
    private static final Map<String, Integer> NAMES_TO_CODES;
    private static final Map<Integer, String> CODES_TO_NAMES;

    public static int forName(String name) throws IllegalArgumentException {
        assert (name != null);
        String tmp = name.toUpperCase();
        Integer code = NAMES_TO_CODES.get(tmp);
        if (code == null) {
            throw new IllegalArgumentException("Invalid ANSI code name: " + name);
        }
        return code;
    }

    public static String name(int code) throws IllegalArgumentException {
        assert (code >= 0);
        String name = CODES_TO_NAMES.get(code);
        if (name == null) {
            throw new IllegalArgumentException("Invalid ANSI code: " + code);
        }
        return name;
    }

    public static String attrib(int attr) {
        return "\u001b[" + attr + "m";
    }

    static {
        Field[] fields = Code.class.getDeclaredFields();
        HashMap<String, Integer> names = new HashMap<String, Integer>(fields.length);
        HashMap<Integer, String> codes = new HashMap<Integer, String>(fields.length);
        try {
            for (Field field : fields) {
                int mods = field.getModifiers();
                if (!Modifier.isPublic(mods)) continue;
                String name = field.getName();
                Integer code = (Integer)field.get(Code.class);
                names.put(name, code);
                codes.put(code, name);
            }
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        NAMES_TO_CODES = names;
        CODES_TO_NAMES = codes;
    }
}

