/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.clp;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ResourceBundle;
import org.apache.geronimo.gshell.clp.ArgumentDescriptor;
import org.apache.geronimo.gshell.clp.CommandLineProcessor;
import org.apache.geronimo.gshell.clp.handler.Handler;

public class Printer {
    private CommandLineProcessor processor;

    public Printer(CommandLineProcessor processor) {
        assert (processor != null);
        this.processor = processor;
    }

    private String getMetaVariable(Handler handler, ResourceBundle bundle) {
        String localized;
        assert (handler != null);
        String token = handler.descriptor.metaVar();
        if (token.length() == 0) {
            token = handler.getDefaultMetaVariable();
        }
        if (token == null) {
            return null;
        }
        if (bundle != null && (localized = bundle.getString(token)) != null) {
            token = localized;
        }
        return token;
    }

    private String getNameAndMeta(Handler handler, ResourceBundle bundle) {
        assert (handler != null);
        String str = handler.descriptor instanceof ArgumentDescriptor ? "" : handler.descriptor.toString();
        String meta = this.getMetaVariable(handler, bundle);
        if (meta != null) {
            if (str.length() > 0) {
                str = str + " ";
            }
            str = str + meta;
        }
        return str;
    }

    private int getPrefixLen(Handler handler, ResourceBundle bundle) {
        assert (handler != null);
        if (handler.descriptor.description().length() == 0) {
            return 0;
        }
        return this.getNameAndMeta(handler, bundle).length();
    }

    public void printUsage(Writer writer, ResourceBundle bundle, String name) {
        int curLen;
        assert (writer != null);
        PrintWriter out = new PrintWriter(writer);
        ArrayList<Handler> argumentHandlers = new ArrayList<Handler>();
        argumentHandlers.addAll(this.processor.getArgumentHandlers());
        ArrayList<Handler> optionHandlers = new ArrayList<Handler>();
        optionHandlers.addAll(this.processor.getOptionHandlers());
        Collections.sort(optionHandlers, new Comparator<Handler>(){

            @Override
            public int compare(Handler a, Handler b) {
                return a.descriptor.toString().compareTo(b.descriptor.toString());
            }
        });
        if (name != null) {
            String syntax = "syntax: " + name;
            if (!optionHandlers.isEmpty()) {
                syntax = syntax + " [options]";
            }
            if (!argumentHandlers.isEmpty()) {
                syntax = syntax + " [arguments]";
            }
            out.println(syntax);
            out.println();
        }
        int len = 0;
        for (Handler handler : optionHandlers) {
            curLen = this.getPrefixLen(handler, bundle);
            len = Math.max(len, curLen);
        }
        for (Handler handler : argumentHandlers) {
            curLen = this.getPrefixLen(handler, bundle);
            len = Math.max(len, curLen);
        }
        if (!argumentHandlers.isEmpty()) {
            out.println("arguments:");
        }
        for (Handler handler : argumentHandlers) {
            this.printHandler(out, handler, len, bundle);
        }
        if (!optionHandlers.isEmpty()) {
            out.println();
            out.println("options:");
        }
        for (Handler handler : optionHandlers) {
            this.printHandler(out, handler, len, bundle);
        }
        out.flush();
    }

    public void printUsage(Writer writer) {
        this.printUsage(writer, null, null);
    }

    public void printUsage(Writer writer, String name) {
        this.printUsage(writer, null, name);
    }

    private void printHandler(PrintWriter out, Handler handler, int len, ResourceBundle bundle) {
        int i;
        assert (out != null);
        assert (handler != null);
        int terminalWidth = 80;
        String prefix = "  ";
        String separator = "    ";
        int prefixSeperatorWidth = prefix.length() + separator.length();
        int descriptionWidth = terminalWidth - len - prefixSeperatorWidth;
        String desc = handler.descriptor.description();
        if (desc.length() == 0) {
            return;
        }
        String nameAndMeta = this.getNameAndMeta(handler, bundle);
        out.print(prefix);
        out.print(nameAndMeta);
        for (i = nameAndMeta.length(); i < len; ++i) {
            out.print(' ');
        }
        out.print(separator);
        if (bundle != null) {
            desc = bundle.getString(desc);
        }
        while (desc != null && desc.length() > 0) {
            i = desc.indexOf(10);
            if (i >= 0 && i <= descriptionWidth) {
                out.println(desc.substring(0, i));
                if ((desc = desc.substring(i + 1)).length() <= 0) continue;
                this.indent(out, len + prefixSeperatorWidth);
                continue;
            }
            if (desc.length() <= descriptionWidth) {
                out.println(desc);
                break;
            }
            out.println(desc.substring(0, descriptionWidth));
            desc = desc.substring(descriptionWidth);
            this.indent(out, len + prefixSeperatorWidth);
        }
    }

    private void indent(PrintWriter out, int i) {
        assert (out != null);
        while (i > 0) {
            out.print(' ');
            --i;
        }
    }
}

