/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.builtins;

import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.geronimo.gshell.ansi.Renderer;
import org.apache.geronimo.gshell.branding.Branding;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.command.annotation.Requirement;
import org.apache.geronimo.gshell.layout.LayoutManager;
import org.apache.geronimo.gshell.layout.model.AliasNode;
import org.apache.geronimo.gshell.layout.model.CommandNode;
import org.apache.geronimo.gshell.layout.model.GroupNode;
import org.apache.geronimo.gshell.layout.model.Node;
import org.apache.geronimo.gshell.registry.CommandRegistry;
import org.apache.geronimo.gshell.registry.NotRegisteredException;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;
import org.codehaus.plexus.util.StringUtils;

@CommandComponent(id="gshell-builtins:help", description="Show command help")
public class HelpCommand
extends OsgiCommandSupport {
    @Requirement
    private CommandRegistry commandRegistry;
    @Requirement
    private LayoutManager layoutManager;
    @Requirement
    private Branding branding;
    @Argument(required=false, multiValued=true)
    private List<String> path;
    private Renderer renderer = new Renderer();

    public HelpCommand(CommandRegistry commandRegistry, LayoutManager layoutManager, Branding branding) {
        this.commandRegistry = commandRegistry;
        this.layoutManager = layoutManager;
        this.branding = branding;
    }

    protected OsgiCommandSupport createCommand() throws Exception {
        return new HelpCommand(this.commandRegistry, this.layoutManager, this.branding);
    }

    protected Object doExecute() throws Exception {
        this.io.out.println();
        GroupNode gn = this.layoutManager.getLayout();
        if (this.context.getVariables().get(LayoutManager.CURRENT_NODE) != null) {
            gn = (GroupNode)this.context.getVariables().get(LayoutManager.CURRENT_NODE);
        }
        CommandNode cn = null;
        if (this.path != null) {
            for (String p : this.path) {
                if (cn != null) {
                    this.io.err.println("Unexpected path '" + p + "'");
                    return FAILURE;
                }
                Node n = gn.find(p);
                if (n == null) {
                    this.io.err.println("Path '" + p + "' not found!");
                    return FAILURE;
                }
                if (n instanceof GroupNode) {
                    gn = (GroupNode)n;
                    continue;
                }
                if (n instanceof CommandNode) {
                    cn = (CommandNode)n;
                    continue;
                }
                if (n instanceof AliasNode) {
                    cn = (CommandNode)this.layoutManager.findNode(gn, ((AliasNode)n).getCommand());
                    continue;
                }
                throw new IllegalStateException("Unsupported node type " + n.getParent().getName());
            }
        }
        if (cn == null) {
            if (gn == this.layoutManager.getLayout()) {
                this.io.out.print(this.branding.getAbout());
                this.io.out.println();
            }
            this.displayGroupCommands(gn);
        } else {
            this.displayCommandHelp(cn.getId());
        }
        return SUCCESS;
    }

    private void displayGroupCommands(GroupNode group) throws Exception {
        Node node;
        int maxNameLen = 20;
        boolean hasShells = false;
        if (group == this.layoutManager.getLayout()) {
            this.io.out.println("Available commands:");
        } else {
            this.io.out.println("Available commands in " + Renderer.encode(group.getName(), 1) + ":");
        }
        TreeSet<Node> nodes = new TreeSet<Node>(new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        nodes.addAll(group.nodes());
        for (Node child : nodes) {
            String name;
            if (child instanceof CommandNode) {
                try {
                    node = (CommandNode)child;
                    name = StringUtils.rightPad(node.getName(), maxNameLen);
                    Command command = this.commandRegistry.lookup(((CommandNode)node).getId());
                    String desc = command.getDescription();
                    this.io.out.print("  ");
                    this.io.out.print(this.renderer.render(Renderer.encode(name, 1)));
                    if (desc != null) {
                        this.io.out.print("  ");
                        this.io.out.println(desc);
                        continue;
                    }
                    this.io.out.println();
                }
                catch (NotRegisteredException e) {}
                continue;
            }
            if (child instanceof AliasNode) {
                node = (AliasNode)child;
                name = StringUtils.rightPad(node.getName(), maxNameLen);
                String cmd = this.layoutManager.findNode(group, ((AliasNode)node).getCommand()).getName();
                this.io.out.print("  ");
                this.io.out.print(this.renderer.render(Renderer.encode(name, 1)));
                this.io.out.print("  ");
                this.io.out.print("Alias to: ");
                this.io.out.println(this.renderer.render(Renderer.encode(cmd, 1)));
                continue;
            }
            if (!(child instanceof GroupNode)) continue;
            hasShells = true;
        }
        this.io.out.println();
        if (hasShells) {
            this.io.out.println("Available shells:");
            for (Node child : nodes) {
                if (!(child instanceof GroupNode)) continue;
                node = (GroupNode)child;
                this.io.out.print("  ");
                this.io.out.println(this.renderer.render(Renderer.encode(node.getName(), 1)));
            }
            this.io.out.println();
        }
    }

    private String extractCommandName(String command) {
        return command.substring(command.lastIndexOf(58) + 1);
    }

    private void displayCommandHelp(String path) throws Exception {
        assert (path != null);
        Command cmd = this.commandRegistry.lookup(path);
        if (cmd == null) {
            this.io.out.println("Command " + Renderer.encode(path, 1) + " not found.");
            this.io.out.println("Try " + Renderer.encode("help", 1) + " for a list of available commands.");
        } else {
            this.io.out.println("Command " + Renderer.encode(this.extractCommandName(path), 1));
            this.io.out.println("   " + cmd.getDescription());
            cmd.execute(this.context, "--help");
        }
        this.io.out.println();
    }
}

