/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.IO;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

@CommandComponent(id="utils:cat", description="Concatenate and print files and/or URLs")
public class CatCommand
extends OsgiCommandSupport {
    @Option(name="-n", description="Number the output lines, starting at 1")
    private boolean displayLineNumbers;
    @Argument(description="File or URL", required=true)
    private List<String> args;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        if (this.args.size() == 1 && "-".equals(this.args.get(0))) {
            this.log.info("Printing STDIN");
            this.cat(new BufferedReader(this.io.in), this.io);
        } else {
            for (String filename : this.args) {
                BufferedReader reader;
                try {
                    URL url = new URL(filename);
                    this.log.info("Printing URL: " + url);
                    reader = new BufferedReader(new InputStreamReader(url.openStream()));
                }
                catch (MalformedURLException ignore) {
                    File file = new File(filename);
                    this.log.info("Printing file: " + file);
                    reader = new BufferedReader(new FileReader(file));
                }
                try {
                    this.cat(reader, this.io);
                }
                finally {
                    IOUtil.close(reader);
                }
            }
        }
        return SUCCESS;
    }

    private void cat(BufferedReader reader, IO io) throws IOException {
        String line;
        int lineno = 1;
        while ((line = reader.readLine()) != null) {
            if (this.displayLineNumbers) {
                String gutter = StringUtils.leftPad(String.valueOf(lineno++), 6);
                io.out.print(gutter);
                io.out.print("  ");
            }
            io.out.println(line);
        }
    }
}

