/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.model.marshal;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.geronimo.gshell.model.marshal.Marshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MarshallerSupport<T>
implements Marshaller<T> {
    private Class rootType;

    protected MarshallerSupport(Class rootType) {
        assert (rootType != null);
        this.rootType = rootType;
    }

    protected XStream createXStream() {
        XStream xs;
        try {
            Class.forName("org.xmlpull.mxp1.MXParser");
            xs = new XStream((HierarchicalStreamDriver)new XppDriver());
        }
        catch (ClassNotFoundException ignore) {
            xs = new XStream((HierarchicalStreamDriver)new DomDriver());
        }
        xs.processAnnotations(this.rootType);
        return xs;
    }

    @Override
    public String marshal(T root) {
        assert (root != null);
        return this.createXStream().toXML(root);
    }

    @Override
    public T unmarshal(InputStream input) {
        assert (input != null);
        return (T)this.createXStream().fromXML(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T unmarshal(URL url) throws IOException {
        assert (url != null);
        InputStream input = url.openStream();
        try {
            T t = this.unmarshal(input);
            return t;
        }
        finally {
            input.close();
        }
    }
}

