/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.remote.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import jline.Terminal;
import org.apache.geronimo.gshell.ExitNotification;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.CommandSupport;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.command.annotation.Requirement;
import org.apache.geronimo.gshell.console.PromptReader;
import org.apache.geronimo.gshell.remote.client.RshClient;
import org.apache.geronimo.gshell.remote.client.proxy.RemoteShellProxy;

@CommandComponent(id="gshell-remote:rsh", description="Connect to a remote GShell server")
public class RshCommand
extends CommandSupport {
    @Option(name="-b", aliases={"--bind"}, metaVar="URI", description="Bind local address to URI")
    private URI local;
    @Option(name="-u", aliases={"--username"}, metaVar="USERNAME", description="Remote user name")
    private String username;
    @Option(name="-p", aliases={"--password"}, metaVar="PASSWORD", description="Remote user password")
    private String password;
    @Argument(metaVar="URI", required=true, index=0, description="Connect to remote server at URI")
    private URI remote;
    @Argument(metaVar="COMMAND", index=1, multiValued=true, description="Execute COMMAND in remote shell")
    private List<String> command = new ArrayList<String>();
    @Requirement
    private Terminal terminal;
    @Requirement
    private PromptReader prompter;
    @Requirement
    private RshClient client;

    protected Object doExecute() throws Exception {
        this.io.info("Connecting to: {}", this.remote);
        this.client.connect(this.remote, this.local);
        this.io.info("Connected");
        if (this.username == null || this.password == null) {
            if (this.username == null) {
                this.username = this.prompter.readLine("Username: ");
            }
            if (this.password == null) {
                this.password = this.prompter.readPassword("Password: ");
            }
        }
        this.client.login(this.username, this.password);
        RemoteShellProxy shell = new RemoteShellProxy(this.client, this.io, this.terminal);
        Object rv = SUCCESS;
        try {
            shell.run(this.command.toArray());
        }
        catch (ExitNotification n) {
            rv = n.code;
        }
        shell.close();
        this.io.verbose("Disconnecting");
        this.client.close();
        this.io.verbose("Disconnected");
        return rv;
    }
}

