/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.remote.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import jline.Terminal;
import org.apache.geronimo.gshell.ExitNotification;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.IO;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.console.PromptReader;
import org.apache.geronimo.gshell.remote.client.SpringRshClient;
import org.apache.geronimo.gshell.remote.client.handler.ClientMessageHandler;
import org.apache.geronimo.gshell.remote.client.proxy.SpringRemoteShellProxy;
import org.apache.geronimo.gshell.remote.crypto.CryptoContext;
import org.apache.geronimo.gshell.spring.NoCloseInputStream;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;
import org.apache.geronimo.gshell.whisper.transport.TransportFactoryLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CommandComponent(id="gshell-remote:rsh", description="Connect to a remote GShell server")
public class SpringRshCommand
extends OsgiCommandSupport {
    @Option(name="-b", aliases={"--bind"}, metaVar="URI", description="Bind local address to URI")
    private URI local;
    @Option(name="-u", aliases={"--username"}, metaVar="USERNAME", description="Remote user name")
    private String username;
    @Option(name="-p", aliases={"--password"}, metaVar="PASSWORD", description="Remote user password")
    private String password;
    @Option(name="-n", aliases={"--name"}, metaVar="NAME", description="Name of the instance to connect to")
    private String name;
    @Argument(metaVar="URI", required=true, index=0, description="Connect to remote server at URI")
    private URI remote;
    @Argument(metaVar="COMMAND", index=1, multiValued=true, description="Execute COMMAND in remote shell")
    private List<String> command = new ArrayList<String>();
    private Terminal terminal;
    private CryptoContext crypto;
    private TransportFactoryLocator locator;
    private List<ClientMessageHandler> handlers;

    public SpringRshCommand(Terminal terminal, CryptoContext crypto, TransportFactoryLocator locator, List<ClientMessageHandler> handlers) {
        this.terminal = terminal;
        this.crypto = crypto;
        this.locator = locator;
        this.handlers = handlers;
    }

    @Override
    protected OsgiCommandSupport createCommand() throws Exception {
        return new SpringRshCommand(this.terminal, this.crypto, this.locator, this.handlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doExecute() throws Exception {
        this.io.info("Connecting to: {}", this.remote);
        final NoCloseInputStream ncis = new NoCloseInputStream(this.io.inputStream);
        IO io = new IO((InputStream)ncis, this.io.outputStream, this.io.errorStream);
        final AtomicBoolean disconnected = new AtomicBoolean(false);
        try {
            SpringRshClient client = new SpringRshClient(this.crypto, this.locator, this.handlers){

                protected void onSessionClosed() {
                    disconnected.set(true);
                    try {
                        ncis.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }

                public String getInstanceName() {
                    return SpringRshCommand.this.name;
                }
            };
            client.initialize();
            PromptReader prompter = new PromptReader(this.terminal, io);
            prompter.initialize();
            client.connect(this.remote, this.local);
            this.io.info("Connected");
            if (this.username == null || this.password == null) {
                if (this.username == null) {
                    this.username = prompter.readLine("Username: ");
                }
                if (this.password == null) {
                    this.password = prompter.readPassword("Password: ");
                }
            }
            client.login(this.username, this.password);
            SpringRemoteShellProxy shell = new SpringRemoteShellProxy(client, io, this.terminal);
            Object rv = SUCCESS;
            try {
                shell.run(this.command.toArray());
            }
            catch (ExitNotification n) {
                rv = n.code;
            }
            if (!disconnected.get()) {
                shell.close();
            }
            this.io.verbose("Disconnecting");
            client.close();
            this.io.verbose("Disconnected");
            Object object = rv;
            return object;
        }
        finally {
            try {
                ncis.close();
            }
            catch (IOException e) {}
        }
    }
}

