/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.remote.server.handler;

import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.geronimo.gshell.remote.jaas.Identity;
import org.apache.geronimo.gshell.remote.jaas.JaasConfigurationHelper;
import org.apache.geronimo.gshell.remote.jaas.UsernamePasswordCallbackHandler;
import org.apache.geronimo.gshell.remote.message.LoginMessage;
import org.apache.geronimo.gshell.remote.server.handler.ServerMessageHandler;
import org.apache.geronimo.gshell.remote.server.handler.ServerMessageHandlerSupport;
import org.apache.geronimo.gshell.remote.server.handler.ServerSessionContext;
import org.apache.geronimo.gshell.remote.server.timeout.TimeoutManager;
import org.apache.geronimo.gshell.whisper.transport.Session;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ServerMessageHandler.class, hint="login")
public class LoginHandler
extends ServerMessageHandlerSupport<LoginMessage>
implements Initializable {
    @Requirement
    private TimeoutManager timeoutManager;

    public LoginHandler() {
        super(LoginMessage.class);
    }

    public LoginHandler(TimeoutManager timeoutManager) {
        this();
        this.timeoutManager = timeoutManager;
    }

    @Override
    public void initialize() throws InitializationException {
        new JaasConfigurationHelper("server.login.conf").initialize();
    }

    @Override
    public void handle(Session session, ServerSessionContext context, LoginMessage message) throws Exception {
        if (!this.timeoutManager.cancelTimeout(session)) {
            this.log.warn("Aborting login processing; timeout has triggered");
        } else {
            String realm = message.getRealm();
            if (realm == null) {
                realm = "BogusLogin";
            }
            String username = message.getUsername();
            char[] password = message.getPassword();
            try {
                LoginContext loginContext = new LoginContext(realm, new UsernamePasswordCallbackHandler(username, password));
                loginContext.login();
                Subject subject = loginContext.getSubject();
                context.identity = new Identity(subject);
                this.log.debug("Username: {}, Identity: {}", (Object)context.getUsername(), (Object)context.identity);
                LoginMessage.Success reply = new LoginMessage.Success(context.identity.getToken());
                reply.setCorrelationId(message.getId());
                session.send(reply);
            }
            catch (LoginException e) {
                String reason = e.toString();
                this.log.debug("Login failed for user: {}, cause: {}", (Object)username, (Object)reason);
                LoginMessage.Failure reply = new LoginMessage.Failure(reason);
                reply.setCorrelationId(message.getId());
                session.send(reply);
            }
        }
    }
}

