/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.spring;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class NoCloseInputStream
extends PipedInputStream {
    private final InputStream in;
    private final PipedOutputStream pos;
    private final Thread thread;
    private IOException exception;

    public NoCloseInputStream(InputStream in) throws IOException {
        this.in = in;
        this.pos = new PipedOutputStream(this);
        this.thread = new Thread(){

            public void run() {
                NoCloseInputStream.this.doRead();
            }
        };
        this.thread.start();
    }

    public synchronized int read() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        return super.read();
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        return super.read(b, off, len);
    }

    public void close() throws IOException {
        super.close();
        this.pos.close();
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRead() {
        try {
            int c;
            while ((c = this.in.read()) != -1) {
                this.pos.write(c);
                NoCloseInputStream noCloseInputStream = this;
                synchronized (noCloseInputStream) {
                    this.notifyAll();
                }
            }
            return;
        }
        catch (IOException e) {
            this.exception = e;
            try {
                this.pos.close();
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

