/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.whisper.request;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.geronimo.gshell.common.Duration;
import org.apache.geronimo.gshell.common.NamedThreadFactory;
import org.apache.geronimo.gshell.common.tostring.ToStringBuilder;
import org.apache.geronimo.gshell.common.tostring.ToStringStyle;
import org.apache.geronimo.gshell.whisper.message.Message;
import org.apache.geronimo.gshell.whisper.request.RequestException;
import org.apache.geronimo.gshell.whisper.request.RequestHandle;
import org.apache.geronimo.gshell.whisper.util.SessionAttributeBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestManager {
    public static final SessionAttributeBinder<RequestManager> BINDER = new SessionAttributeBinder(RequestManager.class);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<Message.ID, Registration> registrations = new HashMap<Message.ID, Registration>();
    private final ScheduledExecutorService scheduler;
    private final Lock lock = new ReentrantLock();

    public RequestManager() {
        NamedThreadFactory tf = new NamedThreadFactory(this.getClass());
        this.scheduler = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors() + 1, tf);
    }

    private Registration get(Message.ID id) {
        assert (id != null);
        Registration reg = this.registrations.get(id);
        if (reg == null) {
            throw new NotRegisteredException(id);
        }
        return reg;
    }

    private Registration remove(Message.ID id) {
        assert (id != null);
        Registration reg = this.registrations.remove(id);
        if (reg == null) {
            throw new NotRegisteredException(id);
        }
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Message.ID id) {
        this.lock.lock();
        try {
            boolean bl = this.registrations.containsKey(id);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(RequestHandle request) {
        assert (request != null);
        this.lock.lock();
        try {
            Message.ID id = request.getId();
            if (this.registrations.containsKey(id)) {
                throw new DuplicateRegistrationException(id);
            }
            Registration reg = new Registration(request);
            this.registrations.put(id, reg);
            this.log.debug("Registered: {}", (Object)reg);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestHandle lookup(Message.ID id) {
        assert (id != null);
        this.lock.lock();
        try {
            Registration reg = this.get(id);
            RequestHandle requestHandle = reg.request;
            return requestHandle;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestHandle deregister(Message.ID id) {
        assert (id != null);
        this.lock.lock();
        try {
            Registration reg = this.remove(id);
            reg.deactivate();
            this.log.debug("Deregistered: {}", (Object)reg);
            RequestHandle requestHandle = reg.request;
            return requestHandle;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(Message.ID id) {
        assert (id != null);
        this.lock.lock();
        try {
            Registration reg = this.get(id);
            reg.activate();
            this.log.debug("Activated: {}", (Object)reg);
        }
        catch (NotRegisteredException e) {
            this.log.debug("Ignoring activation; request not registered: {}", (Object)id);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(Message.ID id) {
        assert (id != null);
        this.lock.lock();
        try {
            Registration reg = this.get(id);
            reg.deactivate();
            this.log.debug("Deactivated: {}", (Object)reg);
        }
        catch (NotRegisteredException e) {
            this.log.debug("Ignoring deactivation; request not registered: {}", (Object)id);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeout(Message.ID id) {
        assert (id != null);
        this.lock.lock();
        try {
            Registration reg = this.remove(id);
            reg.timeout();
            this.log.debug("Timed out: {}", (Object)reg);
        }
        catch (NotRegisteredException e) {
            this.log.debug("Ignoring timeout; request not registered: {}", (Object)id);
        }
        catch (TimeoutAbortedException e) {
            this.log.debug("Timeout aborted: " + e.getMessage());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lock.lock();
        try {
            if (!this.registrations.isEmpty()) {
                this.log.warn("Timing out remaining {} registrations", (Object)this.registrations.size());
                for (Registration reg : this.registrations.values()) {
                    this.timeout(reg.request.getId());
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public class TimeoutAbortedException
    extends RequestException {
        public TimeoutAbortedException(String msg) {
            super(msg);
        }
    }

    public class DuplicateRegistrationException
    extends RequestException {
        public DuplicateRegistrationException(Message.ID id) {
            super(id);
        }
    }

    public class NotRegisteredException
    extends RequestException {
        public NotRegisteredException(Message.ID id) {
            super(id);
        }
    }

    private class Registration {
        public final RequestHandle request;
        public RegistrationState state = RegistrationState.PENDING;
        private ScheduledFuture<?> timeoutFuture;

        public Registration(RequestHandle request) {
            assert (request != null);
            this.request = request;
        }

        public void activate() {
            if (this.state != RegistrationState.PENDING) {
                RequestManager.this.log.debug("Can not activate, state is not PENDING, found: {}", (Object)this.state);
            } else {
                Runnable task = new Runnable(){

                    public void run() {
                        RequestManager.this.timeout(Registration.this.request.getId());
                    }
                };
                Duration timeout = this.request.getTimeout();
                RequestManager.this.log.debug("Scheduling timeout to trigger in: {}", (Object)timeout);
                this.timeoutFuture = RequestManager.this.scheduler.schedule(task, timeout.getValue(), timeout.getUnit());
                this.state = RegistrationState.ACTIVE;
            }
        }

        public void deactivate() {
            if (this.state != RegistrationState.ACTIVE) {
                RequestManager.this.log.debug("Can not deactivate; state is not ACTIVE, found: {}", (Object)this.state);
            } else if (this.timeoutFuture.cancel(false)) {
                this.timeoutFuture = null;
                this.state = RegistrationState.DEACTIVE;
            } else {
                RequestManager.this.log.warn("Unable to cancel registration timeout: {}", (Object)this);
            }
        }

        public void timeout() {
            Message.ID id = this.request.getId();
            if (this.timeoutFuture.isCancelled()) {
                throw new TimeoutAbortedException("Timeout has been canceled: " + id);
            }
            if (this.request.isSignaled()) {
                throw new TimeoutAbortedException("Request has been singled: " + id);
            }
            this.request.timeout();
            this.state = RegistrationState.TIMEDOUT;
        }

        public String toString() {
            return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", this.request.getId()).append("state", (Object)this.state).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RegistrationState {
        PENDING,
        ACTIVE,
        DEACTIVE,
        TIMEDOUT;

    }
}

