/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.whisper.stream;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.geronimo.gshell.common.tostring.ReflectionToStringBuilder;
import org.apache.geronimo.gshell.common.tostring.ToStringStyle;
import org.apache.geronimo.gshell.whisper.stream.StreamMessage;
import org.apache.geronimo.gshell.whisper.util.SessionAttributeBinder;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionOutputStream
extends OutputStream {
    public static final SessionAttributeBinder<SessionOutputStream> BINDER = new SessionAttributeBinder(SessionOutputStream.class);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final IoSession session;
    private WriteFuture lastWriteFuture;
    private volatile boolean opened;

    public SessionOutputStream(IoSession session) {
        assert (session != null);
        this.session = session;
        this.opened = true;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.opened) {
            return;
        }
        try {
            this.flush();
            this.opened = false;
        }
        finally {
            super.close();
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.write(ByteBuffer.wrap((byte[])((byte[])b.clone()), (int)off, (int)len));
    }

    public void write(int b) throws IOException {
        ByteBuffer buff = ByteBuffer.allocate((int)1);
        buff.put((byte)b);
        buff.flip();
        this.write(buff);
    }

    private void ensureOpened() throws IOException {
        if (!this.opened || !this.session.isConnected()) {
            throw new IOException("The session has been closed.");
        }
    }

    private synchronized void write(ByteBuffer buff) throws IOException {
        WriteFuture wf;
        this.ensureOpened();
        this.log.debug("Writing {} bytes", (Object)buff.remaining());
        this.lastWriteFuture = wf = this.session.write((Object)new StreamMessage(buff));
        wf.join();
    }

    public synchronized void flush() throws IOException {
        this.ensureOpened();
        if (this.lastWriteFuture == null) {
            return;
        }
        this.lastWriteFuture.join();
        if (!this.lastWriteFuture.isWritten()) {
            throw new IOException("Failed to fully write bytes to the session");
        }
    }
}

