/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.monitor;

import java.io.UnsupportedEncodingException;
import java.security.Permission;
import java.util.StringTokenizer;

public class MonitorPermission
extends Permission {
    private static final long serialVersionUID = -9084425194463274314L;
    public static final String READ = "read";
    public static final String RESET = "reset";
    public static final String PUBLISH = "publish";
    public static final String STARTJOB = "startjob";
    public static final String SWITCHEVENTS = "switchevents";
    private static final int READ_FLAG = 1;
    private static final int RESET_FLAG = 2;
    private static final int PUBLISH_FLAG = 4;
    private static final int STARTJOB_FLAG = 8;
    private static final int SWITCHEVENTS_FLAG = 16;
    private static final int ALL_FLAGS = 31;
    private String monId;
    private String varId;
    private boolean prefixMonId;
    private boolean prefixVarId;
    private int mask;
    private int minJobInterval;

    public MonitorPermission(String statusVariable, String actions) throws IllegalArgumentException {
        super(statusVariable);
        if (statusVariable == null) {
            throw new IllegalArgumentException("Invalid StatusVariable path 'null'.");
        }
        if (actions == null) {
            throw new IllegalArgumentException("Invalid actions string 'null'.");
        }
        int sep = statusVariable.indexOf(47);
        int len = statusVariable.length();
        if (sep == -1) {
            throw new IllegalArgumentException("Invalid StatusVariable path: should contain '/' separator.");
        }
        if (sep == 0 || sep == statusVariable.length() - 1) {
            throw new IllegalArgumentException("Invalid StatusVariable path: empty monitorable ID or StatusVariable name.");
        }
        this.prefixMonId = statusVariable.charAt(sep - 1) == '*';
        this.prefixVarId = statusVariable.charAt(len - 1) == '*';
        this.monId = statusVariable.substring(0, this.prefixMonId ? sep - 1 : sep);
        this.varId = statusVariable.substring(sep + 1, this.prefixVarId ? len - 1 : len);
        this.checkId(this.monId, "Monitorable ID part of the target");
        this.checkId(this.varId, "Status Variable ID part of the target");
        this.minJobInterval = 0;
        if (actions.equals("*")) {
            this.mask = 31;
        } else {
            this.mask = 0;
            StringTokenizer st = new StringTokenizer(actions, ",");
            while (st.hasMoreTokens()) {
                String action = st.nextToken();
                if (action.equalsIgnoreCase(READ)) {
                    this.addToMask(1, READ);
                    continue;
                }
                if (action.equalsIgnoreCase(RESET)) {
                    this.addToMask(2, RESET);
                    continue;
                }
                if (action.equalsIgnoreCase(PUBLISH)) {
                    this.addToMask(4, PUBLISH);
                    continue;
                }
                if (action.equalsIgnoreCase(SWITCHEVENTS)) {
                    this.addToMask(16, SWITCHEVENTS);
                    continue;
                }
                if (action.toLowerCase().startsWith(STARTJOB)) {
                    this.minJobInterval = 0;
                    int slen = STARTJOB.length();
                    if (action.length() != slen) {
                        if (action.charAt(slen) != ':') {
                            throw new IllegalArgumentException("Invalid action '" + action + "'.");
                        }
                        try {
                            this.minJobInterval = Integer.parseInt(action.substring(slen + 1));
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Invalid parameter in startjob action '" + action + "'.");
                        }
                    }
                    this.addToMask(8, STARTJOB);
                    continue;
                }
                throw new IllegalArgumentException("Invalid action '" + action + "'");
            }
        }
    }

    private void addToMask(int action, String actionString) {
        if ((this.mask & action) != 0) {
            throw new IllegalArgumentException("Invalid action string: " + actionString + " appears multiple times.");
        }
        this.mask |= action;
    }

    private void checkId(String id, String idName) throws IllegalArgumentException {
        byte[] nameBytes;
        try {
            nameBytes = id.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage());
        }
        if (nameBytes.length > 32) {
            throw new IllegalArgumentException(idName + " is too long (over " + 32 + " bytes in UTF-8 encoding).");
        }
        if (id.equals(".") || id.equals("..")) {
            throw new IllegalArgumentException(idName + " is invalid.");
        }
        char[] chars = id.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if ("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.".indexOf(chars[i]) != -1) continue;
            throw new IllegalArgumentException(idName + " contains invalid characters.");
        }
    }

    public int hashCode() {
        return new Integer(this.mask).hashCode() ^ new Integer(this.minJobInterval).hashCode() ^ this.monId.hashCode() ^ new Boolean(this.prefixMonId).hashCode() ^ this.varId.hashCode() ^ new Boolean(this.prefixVarId).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MonitorPermission)) {
            return false;
        }
        MonitorPermission other = (MonitorPermission)o;
        return this.mask == other.mask && this.minJobInterval == other.minJobInterval && this.monId.equals(other.monId) && this.prefixMonId == other.prefixMonId && this.varId.equals(other.varId) && this.prefixVarId == other.prefixVarId;
    }

    public String getActions() {
        StringBuffer sb = new StringBuffer();
        this.appendAction(sb, 1, READ);
        this.appendAction(sb, 2, RESET);
        this.appendAction(sb, 4, PUBLISH);
        this.appendAction(sb, 8, STARTJOB);
        this.appendAction(sb, 16, SWITCHEVENTS);
        return sb.toString();
    }

    private void appendAction(StringBuffer sb, int flag, String actionName) {
        if ((this.mask & flag) != 0) {
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(actionName);
            if (flag == 8 && this.minJobInterval != 0) {
                sb.append(':').append(this.minJobInterval);
            }
        }
    }

    public boolean implies(Permission p) {
        if (!(p instanceof MonitorPermission)) {
            return false;
        }
        MonitorPermission other = (MonitorPermission)p;
        if ((this.mask & other.mask) != other.mask) {
            return false;
        }
        if ((other.mask & 8) != 0 && this.minJobInterval > other.minJobInterval) {
            return false;
        }
        return this.implies(this.monId, this.prefixMonId, other.monId, other.prefixMonId) && this.implies(this.varId, this.prefixVarId, other.varId, other.prefixVarId);
    }

    private boolean implies(String id, boolean prefix, String oid, boolean oprefix) {
        return prefix ? oid.startsWith(id) : !oprefix && id.equals(oid);
    }
}

