/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.gsm;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.osgi.framework.Bundle;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;

public class IMSICondition {
    private static final String ORG_OSGI_UTIL_GSM_IMSI = "org.osgi.util.gsm.imsi";
    private static final String imsi = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty(IMSICondition.ORG_OSGI_UTIL_GSM_IMSI);
        }
    });

    private IMSICondition() {
    }

    public static Condition getCondition(Bundle bundle, ConditionInfo conditionInfo) {
        if (bundle == null) {
            throw new NullPointerException("bundle");
        }
        if (conditionInfo == null) {
            throw new NullPointerException("conditionInfo");
        }
        String imsi = conditionInfo.getArgs()[0];
        if (imsi.length() > 15) {
            throw new IllegalArgumentException("imsi too long: " + imsi);
        }
        if (imsi.endsWith("*")) {
            imsi = imsi.substring(0, imsi.length() - 1);
        } else if (imsi.length() != 15) {
            throw new IllegalArgumentException("not a valid imei: " + imsi);
        }
        for (int i = 0; i < imsi.length(); ++i) {
            char c = imsi.charAt(i);
            if (c >= '0' && c <= '9') continue;
            throw new IllegalArgumentException("not a valid imei: " + imsi);
        }
        if (IMSICondition.imsi == null) {
            System.err.println("The OSGi Reference Implementation of org.osgi.util.gsm.IMSICondition ");
            System.err.println("needs the system property org.osgi.util.gsm.imsi set.");
            return Condition.FALSE;
        }
        return IMSICondition.imsi.startsWith(imsi) ? Condition.TRUE : Condition.FALSE;
    }
}

