/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.admin.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.util.Properties;
import org.apache.servicemix.jpm.Process;
import org.apache.servicemix.jpm.ProcessBuilderFactory;
import org.apache.servicemix.jpm.impl.ScriptUtils;
import org.apache.servicemix.kernel.gshell.admin.Instance;
import org.apache.servicemix.kernel.gshell.admin.internal.AdminServiceImpl;

public class InstanceImpl
implements Instance {
    private AdminServiceImpl service;
    private String name;
    private String location;
    private Process process;

    public InstanceImpl(AdminServiceImpl service, String name, String location) {
        this.service = service;
        this.name = name;
        this.location = location;
    }

    public void attach(int pid) throws IOException {
        this.checkProcess();
        if (this.process != null) {
            throw new IllegalStateException("Instance already started");
        }
        this.process = ProcessBuilderFactory.newInstance().newBuilder().attach(pid);
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public int getPid() {
        this.checkProcess();
        return this.process != null ? this.process.getPid() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPort() throws Exception {
        InputStream is = null;
        try {
            File f = new File(this.location, "etc/org.apache.servicemix.shell.cfg");
            is = new FileInputStream(f);
            Properties props = new Properties();
            props.load(is);
            String loc = props.getProperty("remoteShellLocation");
            URI uri = new URI(loc);
            int n = uri.getPort();
            return n;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePort(int port) throws Exception {
        this.checkProcess();
        if (this.process != null) {
            throw new IllegalStateException("Instance not stopped");
        }
        Properties props = new Properties();
        File f = new File(this.location, "etc/org.apache.servicemix.shell.cfg");
        FileInputStream is = new FileInputStream(f);
        try {
            props.load(is);
        }
        finally {
            ((InputStream)is).close();
        }
        String loc = props.getProperty("remoteShellLocation");
        loc = loc.replace(Integer.toString(new URI(loc).getPort()), Integer.toString(port));
        props.setProperty("remoteShellLocation", loc);
        FileOutputStream os = new FileOutputStream(f);
        try {
            props.store(os, null);
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public synchronized void start(String javaOpts) throws Exception {
        this.checkProcess();
        if (this.process != null) {
            throw new IllegalStateException("Instance already started");
        }
        if (javaOpts == null) {
            javaOpts = "-server -Xms128M -Xmx512M -Dcom.sun.management.jmxremote";
        }
        String command = new File(System.getProperty("java.home"), "bin/java" + (ScriptUtils.isWindows() ? ".exe" : "")).getCanonicalPath() + " " + javaOpts + " -Dservicemix.home=\"" + System.getProperty("servicemix.home") + "\"" + " -Dservicemix.base=\"" + new File(this.location).getCanonicalPath() + "\"" + " -Dservicemix.startLocalConsole=false" + " -Dservicemix.startRemoteShell=true" + " -classpath " + new File(System.getProperty("servicemix.home"), "lib/servicemix.jar").getCanonicalPath() + System.getProperty("path.separator") + new File(System.getProperty("servicemix.home"), "lib/servicemix-jaas-boot.jar").getCanonicalPath() + " org.apache.servicemix.kernel.main.Main";
        this.process = ProcessBuilderFactory.newInstance().newBuilder().directory(new File(this.location)).command(command).start();
        this.service.saveState();
    }

    public synchronized void stop() throws Exception {
        this.checkProcess();
        if (this.process == null) {
            throw new IllegalStateException("Instance not started");
        }
        this.process.destroy();
    }

    public synchronized void destroy() throws Exception {
        this.checkProcess();
        if (this.process != null) {
            throw new IllegalStateException("Instance not stopped");
        }
        InstanceImpl.deleteFile(new File(this.location));
        this.service.forget(this.name);
        this.service.saveState();
    }

    public synchronized String getState() {
        this.checkProcess();
        if (this.process == null) {
            return "Stopped";
        }
        try {
            int port = this.getPort();
            Socket s = new Socket("localhost", port);
            s.close();
            return "Started";
        }
        catch (Exception exception) {
            return "Starting";
        }
    }

    protected void checkProcess() {
        if (this.process != null) {
            try {
                if (!this.process.isRunning()) {
                    this.process = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static boolean deleteFile(File fileToDelete) {
        if (fileToDelete == null || !fileToDelete.exists()) {
            return true;
        }
        boolean result = true;
        if (fileToDelete.isDirectory()) {
            File[] files = fileToDelete.listFiles();
            if (files == null) {
                result = false;
            } else {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (file.getName().equals(".") || file.getName().equals("..")) continue;
                    if (file.isDirectory()) {
                        result &= InstanceImpl.deleteFile(file);
                        continue;
                    }
                    result &= file.delete();
                }
            }
        }
        return result &= fileToDelete.delete();
    }
}

