/*
 * Decompiled with CFR 0.152.
 */
package org.drools.analytics.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.drools.analytics.components.AnalyticsClass;
import org.drools.analytics.components.AnalyticsRule;
import org.drools.analytics.components.Constraint;
import org.drools.analytics.components.Field;
import org.drools.analytics.components.FieldClassLink;
import org.drools.analytics.components.Pattern;
import org.drools.analytics.components.PatternPossibility;
import org.drools.analytics.components.Restriction;
import org.drools.analytics.components.RulePackage;
import org.drools.analytics.components.RulePossibility;
import org.drools.analytics.components.Variable;
import org.drools.analytics.dao.AnalyticsData;
import org.drools.analytics.result.Gap;
import org.drools.analytics.result.MissingNumberPattern;
import org.drools.analytics.result.RangeCheckCause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnalyticsDataMaps
implements AnalyticsData {
    private Map<Integer, RulePackage> packagesById = new TreeMap<Integer, RulePackage>();
    private Map<String, RulePackage> packagesByName = new TreeMap<String, RulePackage>();
    private Map<Integer, AnalyticsClass> classesById = new TreeMap<Integer, AnalyticsClass>();
    private Map<String, AnalyticsClass> classesByName = new TreeMap<String, AnalyticsClass>();
    private Map<String, Field> fieldsByClassAndFieldName = new TreeMap<String, Field>();
    private Map<Integer, Field> fieldsById = new TreeMap<Integer, Field>();
    private Map<Integer, Set<Field>> fieldsByClassId = new TreeMap<Integer, Set<Field>>();
    private Map<String, FieldClassLink> fieldClassLinkByIds = new TreeMap<String, FieldClassLink>();
    private Map<Integer, AnalyticsRule> rulesById = new TreeMap<Integer, AnalyticsRule>();
    private Map<Integer, Pattern> patternsById = new TreeMap<Integer, Pattern>();
    private Map<Integer, Set<Pattern>> patternsByClassId = new TreeMap<Integer, Set<Pattern>>();
    private Map<String, Set<Pattern>> patternsByRuleName = new TreeMap<String, Set<Pattern>>();
    private Map<Integer, Constraint> constraintsById = new TreeMap<Integer, Constraint>();
    private Map<Integer, Restriction> restrictionsById = new TreeMap<Integer, Restriction>();
    private Map<Integer, Set<Restriction>> restrictionsByFieldId = new TreeMap<Integer, Set<Restriction>>();
    private Map<String, Variable> variablesByRuleAndVariableName = new TreeMap<String, Variable>();
    private Map<Integer, PatternPossibility> patternPossibilitiesById = new TreeMap<Integer, PatternPossibility>();
    private Map<Integer, RulePossibility> rulePossibilitiesById = new TreeMap<Integer, RulePossibility>();
    private Map<Integer, Gap> gapsById = new TreeMap<Integer, Gap>();
    private Map<Integer, Set<Gap>> gapsByFieldId = new TreeMap<Integer, Set<Gap>>();
    private Map<Integer, MissingNumberPattern> missingNumberPatternsById = new TreeMap<Integer, MissingNumberPattern>();
    private Map<Integer, Set<MissingNumberPattern>> missingNumberPatternsByFieldId = new TreeMap<Integer, Set<MissingNumberPattern>>();

    AnalyticsDataMaps() {
    }

    @Override
    public void save(AnalyticsClass clazz) {
        this.classesById.put(clazz.getId(), clazz);
        this.classesByName.put(clazz.getName(), clazz);
    }

    @Override
    public void save(Field field) {
        AnalyticsClass clazz = this.classesById.get(field.getClassId());
        this.fieldsByClassAndFieldName.put(clazz.getName() + "." + field.getName(), field);
        this.fieldsById.put(field.getId(), field);
        if (this.fieldsByClassId.containsKey(field.getClassId())) {
            Set<Field> set = this.fieldsByClassId.get(field.getClassId());
            set.add(field);
        } else {
            HashSet<Field> set = new HashSet<Field>();
            set.add(field);
            this.fieldsByClassId.put(field.getClassId(), set);
        }
    }

    @Override
    public void save(Variable variable) {
        AnalyticsRule rule = this.rulesById.get(variable.getRuleId());
        this.variablesByRuleAndVariableName.put(rule.getRuleName() + "." + variable.getName(), variable);
    }

    @Override
    public void save(AnalyticsRule rule) {
        this.rulesById.put(rule.getId(), rule);
    }

    @Override
    public void save(Pattern pattern) {
        Set<Object> set;
        this.patternsById.put(pattern.getId(), pattern);
        if (this.patternsByClassId.containsKey(pattern.getClassId())) {
            set = this.patternsByClassId.get(pattern.getClassId());
            set.add(pattern);
        } else {
            set = new HashSet<Pattern>();
            set.add(pattern);
            this.patternsByClassId.put(pattern.getClassId(), set);
        }
        if (this.patternsByRuleName.containsKey(pattern.getRuleName())) {
            set = this.patternsByRuleName.get(pattern.getRuleName());
            set.add(pattern);
        } else {
            set = new HashSet();
            set.add(pattern);
            this.patternsByRuleName.put(pattern.getRuleName(), set);
        }
    }

    @Override
    public void save(Constraint constraint) {
        this.constraintsById.put(constraint.getId(), constraint);
    }

    @Override
    public void save(Restriction restriction) {
        this.restrictionsById.put(restriction.getId(), restriction);
        if (this.restrictionsByFieldId.containsKey(restriction.getFieldId())) {
            Set<Restriction> set = this.restrictionsByFieldId.get(restriction.getFieldId());
            set.add(restriction);
        } else {
            HashSet<Restriction> set = new HashSet<Restriction>();
            set.add(restriction);
            this.restrictionsByFieldId.put(restriction.getFieldId(), set);
        }
    }

    @Override
    public void save(FieldClassLink link) {
        this.fieldClassLinkByIds.put(link.getFieldId() + "." + link.getClassId(), link);
    }

    @Override
    public AnalyticsClass getClassByPackageAndName(String name) {
        return this.classesByName.get(name);
    }

    @Override
    public Field getFieldByClassAndFieldName(String className, String fieldName) {
        return this.fieldsByClassAndFieldName.get(className + "." + fieldName);
    }

    @Override
    public Variable getVariableByRuleAndVariableName(String ruleName, String variableName) {
        return this.variablesByRuleAndVariableName.get(ruleName + "." + variableName);
    }

    @Override
    public FieldClassLink getFieldClassLink(int id, int id2) {
        return this.fieldClassLinkByIds.get(id + "." + id2);
    }

    @Override
    public Collection<AnalyticsRule> getAllRules() {
        return this.rulesById.values();
    }

    @Override
    public void save(PatternPossibility possibility) {
        this.patternPossibilitiesById.put(possibility.getId(), possibility);
    }

    @Override
    public void save(RulePossibility possibility) {
        this.rulePossibilitiesById.put(possibility.getId(), possibility);
    }

    @Override
    public Collection<AnalyticsClass> getClassesByRuleName(String ruleName) {
        HashSet<AnalyticsClass> set = new HashSet<AnalyticsClass>();
        for (Pattern pattern : this.patternsByRuleName.get(ruleName)) {
            AnalyticsClass clazz = this.getClassById(pattern.getClassId());
            set.add(clazz);
        }
        return set;
    }

    @Override
    public AnalyticsClass getClassById(int id) {
        return this.classesById.get(id);
    }

    @Override
    public Collection<? extends Object> getAll() {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.addAll(this.packagesById.values());
        objects.addAll(this.rulesById.values());
        objects.addAll(this.patternsById.values());
        objects.addAll(this.constraintsById.values());
        objects.addAll(this.restrictionsById.values());
        objects.addAll(this.patternPossibilitiesById.values());
        objects.addAll(this.rulePossibilitiesById.values());
        objects.addAll(this.classesByName.values());
        objects.addAll(this.fieldsByClassAndFieldName.values());
        objects.addAll(this.variablesByRuleAndVariableName.values());
        return objects;
    }

    @Override
    public Collection<AnalyticsClass> getAllClasses() {
        return this.classesById.values();
    }

    @Override
    public Collection<Field> getFieldsByClassId(int id) {
        return this.fieldsByClassId.get(id);
    }

    @Override
    public Collection<AnalyticsRule> getRulesByClassId(int id) {
        HashSet<AnalyticsRule> rules = new HashSet<AnalyticsRule>();
        for (Pattern pattern : this.patternsByClassId.get(id)) {
            rules.add(this.rulesById.get(pattern.getRuleId()));
        }
        return rules;
    }

    @Override
    public Collection<Field> getAllFields() {
        return this.fieldsById.values();
    }

    @Override
    public Collection<AnalyticsRule> getRulesByFieldId(int id) {
        HashSet<AnalyticsRule> rules = new HashSet<AnalyticsRule>();
        for (Restriction restriction : this.restrictionsByFieldId.get(id)) {
            rules.add(this.rulesById.get(restriction.getRuleId()));
        }
        return rules;
    }

    @Override
    public Collection<RulePackage> getAllRulePackages() {
        return this.packagesById.values();
    }

    @Override
    public void save(RulePackage rulePackage) {
        this.packagesById.put(rulePackage.getId(), rulePackage);
        this.packagesByName.put(rulePackage.getName(), rulePackage);
    }

    @Override
    public RulePackage getRulePackageByName(String name) {
        return this.packagesByName.get(name);
    }

    @Override
    public void save(Gap gap) {
        this.gapsById.put(gap.getId(), gap);
        if (this.gapsByFieldId.containsKey(gap.getField().getId())) {
            Set<Gap> set = this.gapsByFieldId.get(gap.getField().getId());
            set.add(gap);
        } else {
            HashSet<Gap> set = new HashSet<Gap>();
            set.add(gap);
            this.gapsByFieldId.put(gap.getField().getId(), set);
        }
    }

    @Override
    public void remove(Gap gap) {
        this.gapsById.remove(gap.getId());
        if (this.gapsByFieldId.containsKey(gap.getField().getId())) {
            Set<Gap> set = this.gapsByFieldId.get(gap.getField().getId());
            set.remove(gap);
            if (set.isEmpty()) {
                this.gapsByFieldId.remove(gap.getField().getId());
            }
        }
    }

    @Override
    public Collection<Field> getFieldsWithGaps() {
        Set<Integer> set = this.gapsByFieldId.keySet();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Integer i : set) {
            fields.add(this.fieldsById.get(i));
        }
        return fields;
    }

    @Override
    public Collection<Gap> getGapsByFieldId(int fieldId) {
        return this.gapsByFieldId.get(fieldId);
    }

    @Override
    public Collection<Restriction> getRestrictionsByFieldId(int id) {
        return this.restrictionsByFieldId.get(id);
    }

    @Override
    public Collection<RangeCheckCause> getRangeCheckCauses() {
        ArrayList<RangeCheckCause> result = new ArrayList<RangeCheckCause>();
        result.addAll(this.gapsById.values());
        result.addAll(this.missingNumberPatternsById.values());
        return result;
    }

    @Override
    public void save(MissingNumberPattern missingNumberPattern) {
        this.missingNumberPatternsById.put(missingNumberPattern.getId(), missingNumberPattern);
        if (this.missingNumberPatternsByFieldId.containsKey(missingNumberPattern.getField().getId())) {
            Set<MissingNumberPattern> set = this.missingNumberPatternsByFieldId.get(missingNumberPattern.getField().getId());
            set.add(missingNumberPattern);
        } else {
            HashSet<MissingNumberPattern> set = new HashSet<MissingNumberPattern>();
            set.add(missingNumberPattern);
            this.missingNumberPatternsByFieldId.put(missingNumberPattern.getField().getId(), set);
        }
    }

    @Override
    public Collection<RangeCheckCause> getRangeCheckCausesByFieldId(int id) {
        ArrayList<RangeCheckCause> result = new ArrayList<RangeCheckCause>();
        if (this.gapsByFieldId.containsKey(id)) {
            result.addAll((Collection)this.gapsByFieldId.get(id));
        }
        if (this.missingNumberPatternsByFieldId.containsKey(id)) {
            result.addAll((Collection<RangeCheckCause>)this.missingNumberPatternsByFieldId.get(id));
        }
        return result;
    }
}

