/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import org.drools.repository.AssetItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;

public class AssetHistoryIterator
implements Iterator {
    private Node head;
    private VersionIterator versionIterator;
    private RulesRepository repo;

    public AssetHistoryIterator(RulesRepository repo, Node head) {
        this.head = head;
        this.repo = repo;
        try {
            this.versionIterator = this.head.getVersionHistory().getAllVersions();
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public boolean hasNext() {
        return this.versionIterator.hasNext();
    }

    public Object next() {
        return new AssetItem(this.repo, (Node)((Version)this.versionIterator.next()));
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void skip(int i) {
        this.versionIterator.skip((long)i);
    }
}

