/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.builder;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.TupleSource;
import org.drools.rule.RuleConditionElement;

public class BuildContext {
    private TupleSource tupleSource;
    private ObjectSource objectSource;
    private LinkedList objectType;
    private int currentPatternOffset;
    private InternalRuleBase rulebase;
    private InternalWorkingMemory[] workingMemories;
    private ReteooBuilder.IdGenerator idGenerator;
    private LinkedList buildstack;
    private List betaconstraints;
    private List alphaConstraints;
    private boolean tupleMemoryEnabled;
    private boolean objectTypeNodeMemoryEnabled;
    private boolean terminalNodeMemoryEnabled;
    private boolean alphaNodeMemoryAllowed;

    public BuildContext(InternalRuleBase rulebase, ReteooBuilder.IdGenerator idGenerator) {
        this.rulebase = rulebase;
        this.idGenerator = idGenerator;
        this.workingMemories = null;
        this.objectType = null;
        this.buildstack = null;
        this.tupleSource = null;
        this.objectSource = null;
        this.currentPatternOffset = 0;
        this.tupleMemoryEnabled = true;
        this.objectTypeNodeMemoryEnabled = true;
    }

    public int getCurrentPatternOffset() {
        return this.currentPatternOffset;
    }

    public void setCurrentPatternOffset(int currentPatternIndex) {
        this.currentPatternOffset = currentPatternIndex;
        this.syncObjectTypesWithPatternOffset();
    }

    public void syncObjectTypesWithPatternOffset() {
        if (this.objectType == null) {
            this.objectType = new LinkedList();
        }
        while (this.objectType.size() > this.currentPatternOffset) {
            this.objectType.removeLast();
        }
    }

    public ObjectSource getObjectSource() {
        return this.objectSource;
    }

    public void setObjectSource(ObjectSource objectSource) {
        this.objectSource = objectSource;
    }

    public LinkedList getObjectType() {
        if (this.objectType == null) {
            this.objectType = new LinkedList();
        }
        return this.objectType;
    }

    public void setObjectType(LinkedList objectType) {
        if (this.objectType == null) {
            this.objectType = new LinkedList();
        }
        this.objectType = objectType;
    }

    public TupleSource getTupleSource() {
        return this.tupleSource;
    }

    public void setTupleSource(TupleSource tupleSource) {
        this.tupleSource = tupleSource;
    }

    public void incrementCurrentPatternOffset() {
        ++this.currentPatternOffset;
    }

    public void decrementCurrentPatternOffset() {
        --this.currentPatternOffset;
        this.syncObjectTypesWithPatternOffset();
    }

    public InternalRuleBase getRuleBase() {
        return this.rulebase;
    }

    public InternalWorkingMemory[] getWorkingMemories() {
        if (this.workingMemories == null) {
            this.workingMemories = this.rulebase.getWorkingMemories();
        }
        return this.workingMemories;
    }

    public int getNextId() {
        return this.idGenerator.getNextId();
    }

    public void releaseId() {
        this.idGenerator.releaseLastId();
    }

    public void push(RuleConditionElement rce) {
        if (this.buildstack == null) {
            this.buildstack = new LinkedList();
        }
        this.buildstack.addLast(rce);
    }

    public RuleConditionElement pop() {
        if (this.buildstack == null) {
            this.buildstack = new LinkedList();
        }
        return (RuleConditionElement)this.buildstack.removeLast();
    }

    public RuleConditionElement peek() {
        if (this.buildstack == null) {
            this.buildstack = new LinkedList();
        }
        return (RuleConditionElement)this.buildstack.getLast();
    }

    public ListIterator stackIterator() {
        if (this.buildstack == null) {
            this.buildstack = new LinkedList();
        }
        return this.buildstack.listIterator();
    }

    public List getBetaconstraints() {
        return this.betaconstraints;
    }

    public void setBetaconstraints(List betaconstraints) {
        this.betaconstraints = betaconstraints;
    }

    public int getNextSequence(String groupName) {
        Integer seq = (Integer)this.rulebase.getAgendaGroupRuleTotals().get(groupName);
        if (seq == null) {
            seq = new Integer(0);
        }
        Integer newSeq = new Integer(seq + 1);
        this.rulebase.getAgendaGroupRuleTotals().put(groupName, newSeq);
        return newSeq;
    }

    public List getAlphaConstraints() {
        return this.alphaConstraints;
    }

    public void setAlphaConstraints(List alphaConstraints) {
        this.alphaConstraints = alphaConstraints;
    }

    public boolean isTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public void setTupleMemoryEnabled(boolean hasLeftMemory) {
        this.tupleMemoryEnabled = hasLeftMemory;
    }

    public boolean isObjectTypeNodeMemoryEnabled() {
        return this.objectTypeNodeMemoryEnabled;
    }

    public void setObjectTypeNodeMemoryEnabled(boolean hasObjectTypeMemory) {
        this.objectTypeNodeMemoryEnabled = hasObjectTypeMemory;
    }

    public boolean isTerminalNodeMemoryEnabled() {
        return this.terminalNodeMemoryEnabled;
    }

    public void setTerminalNodeMemoryEnabled(boolean hasTerminalNodeMemory) {
        this.terminalNodeMemoryEnabled = hasTerminalNodeMemory;
    }

    public void setAlphaNodeMemoryAllowed(boolean alphaMemoryAllowed) {
        this.alphaNodeMemoryAllowed = alphaMemoryAllowed;
    }

    public boolean isAlphaMemoryAllowed() {
        return this.alphaNodeMemoryAllowed;
    }
}

