/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.drools.base.mvel.DroolsMVELFactory;
import org.drools.base.mvel.MVELConsequence;
import org.drools.compiler.Dialect;
import org.drools.compiler.RuleError;
import org.drools.rule.builder.ConsequenceBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.mvel.Macro;
import org.mvel.MacroProcessor;

public class MVELConsequenceBuilder
implements ConsequenceBuilder {
    private static final Map macros = new HashMap(5);

    public void build(RuleBuildContext context) {
        context.getBuildStack().push(context.getRule().getLhs());
        try {
            MVELDialect dialect = (MVELDialect)context.getDialect();
            String text = MVELConsequenceBuilder.processMacros((String)context.getRuleDescr().getConsequence());
            Dialect.AnalysisResult analysis = dialect.analyzeBlock(context, context.getRuleDescr(), dialect.getInterceptors(), text, null);
            Serializable expr = dialect.compile(text, analysis, dialect.getInterceptors(), null, null, context);
            DroolsMVELFactory factory = new DroolsMVELFactory(context.getDeclarationResolver().getDeclarations(), null, context.getPkg().getGlobals(), analysis.getBoundIdentifiers());
            context.getRule().setConsequence(new MVELConsequence(expr, factory));
        }
        catch (Exception e) {
            context.getErrors().add(new RuleError(context.getRule(), context.getRuleDescr(), null, "Unable to build expression for 'consequence': " + e.getMessage() + " '" + context.getRuleDescr().getConsequence() + "'"));
        }
    }

    public static String processMacros(String consequence) {
        MacroProcessor macroProcessor = new MacroProcessor();
        macroProcessor.setMacros(macros);
        return macroProcessor.parse(MVELConsequenceBuilder.delimitExpressions(consequence));
    }

    public static String delimitExpressions(String s) {
        StringBuffer result = new StringBuffer();
        char[] cs = s.toCharArray();
        int brace = 0;
        int sqre = 0;
        int crly = 0;
        int lastNonWhite = 59;
        for (int i = 0; i < cs.length; ++i) {
            int c = cs[i];
            switch (c) {
                case 40: {
                    ++brace;
                    break;
                }
                case 123: {
                    ++crly;
                    break;
                }
                case 91: {
                    ++sqre;
                    break;
                }
                case 41: {
                    --brace;
                    break;
                }
                case 125: {
                    --crly;
                    break;
                }
                case 93: {
                    --sqre;
                    break;
                }
            }
            if (brace == 0 && sqre == 0 && crly == 0 && (c == 10 || c == 13)) {
                if (lastNonWhite != 59) {
                    result.append(';');
                    lastNonWhite = 59;
                }
            } else if (!Character.isWhitespace((char)c)) {
                lastNonWhite = c;
            }
            result.append((char)c);
        }
        return result.toString();
    }

    static {
        macros.put("insert", new Macro(){

            public String doMacro() {
                return "drools.insert";
            }
        });
        macros.put("insertLogical", new Macro(){

            public String doMacro() {
                return "drools.insertLogical";
            }
        });
        macros.put("modify", new Macro(){

            public String doMacro() {
                return "@Modify with";
            }
        });
        macros.put("update", new Macro(){

            public String doMacro() {
                return "drools.update";
            }
        });
        macros.put("retract", new Macro(){

            public String doMacro() {
                return "drools.retract";
            }
        });
    }
}

