/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scm.jcr;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.RulesRepository;
import org.drools.scm.DefaultScmEntry;
import org.drools.scm.ScmAction;
import org.drools.scm.ScmActionFactory;
import org.drools.scm.log.ScmLogEntry;
import org.drools.scm.log.ScmLogEntryItem;

public class JcrActionFactory
implements ScmActionFactory {
    private RulesRepository repository;

    public JcrActionFactory(RulesRepository repo) {
        this.repository = repo;
    }

    public ScmAction addDirectory(String root, String path) {
        return new AddDirectory(root, path);
    }

    public ScmAction addFile(String path, String file, byte[] content) {
        return new AddFile(path, file, content);
    }

    public ScmAction copyDirectory(String path, String newPath, long revision) {
        return null;
    }

    public ScmAction copyFile(String path, String file, String newPath, String newFile, long revision) {
        return null;
    }

    public ScmAction deleteDirectory(String path) {
        return null;
    }

    public ScmAction deleteFile(String path, String file) {
        return null;
    }

    public void execute(ScmAction action, String message) throws Exception {
        action.applyAction(new RepositoryContext(this.repository, message));
        this.repository.save();
    }

    public void getContent(String path, String file, long revision, OutputStream os) throws Exception {
    }

    public long getLatestRevision() throws Exception {
        return 0L;
    }

    public List listEntries(String path) throws Exception {
        ArrayList<PackageItem> pkgs = new ArrayList<PackageItem>();
        String pathAsPackageName = JcrActionFactory.toPackageName(path);
        Iterator it = this.repository.listPackages();
        while (it.hasNext()) {
            PackageItem pkgItem = (PackageItem)it.next();
            if (!pkgItem.getName().startsWith(pathAsPackageName)) continue;
            pkgs.add(pkgItem);
        }
        Collections.sort(pkgs, new PackagePathComparator());
        ArrayList<DefaultScmEntry> entries = new ArrayList<DefaultScmEntry>();
        String parentPath = path;
        Iterator pkgIter = pkgs.iterator();
        while (pkgIter.hasNext()) {
            PackageItem item = (PackageItem)pkgIter.next();
            DefaultScmEntry scmEntry = new DefaultScmEntry();
            scmEntry.setPath(parentPath);
            String name = JcrActionFactory.toDirectoryName(item.getName()).substring(parentPath.length());
            scmEntry.setName(name);
            scmEntry.setAuthor(item.getPublisher());
            scmEntry.setDate(item.getLastModified().getTime());
            scmEntry.setRevision(new Long(item.getVersionNumber()));
            scmEntry.setSize(0L);
            scmEntry.setType(0);
            entries.add(scmEntry);
            String pkgNameAsPath = JcrActionFactory.toDirectoryName(item.getName());
            Iterator assetIter = item.getAssets();
            while (assetIter.hasNext()) {
                AssetItem assetItem = (AssetItem)assetIter.next();
                if (assetItem.getVersionNumber() == 0L) continue;
                scmEntry = new DefaultScmEntry();
                scmEntry.setPath(pkgNameAsPath);
                scmEntry.setName(JcrActionFactory.toFileName(assetItem));
                scmEntry.setAuthor(assetItem.getPublisher());
                scmEntry.setDate(assetItem.getLastModified().getTime());
                scmEntry.setRevision(new Long(assetItem.getVersionNumber()));
                scmEntry.setSize(0L);
                scmEntry.setType(0);
                entries.add(scmEntry);
            }
        }
        return entries;
    }

    public ScmAction moveDirectory(String path, String newPath, long revision) {
        return null;
    }

    public ScmAction moveFile(String path, String file, String newPath, String newFile, long revision) {
        return null;
    }

    public ScmAction updateFile(String path, String file, byte[] oldContent, byte[] newContent) {
        return new UpdateFile(path, file, oldContent, newContent);
    }

    public void syncToScmLog(List list, ScmActionFactory factory) throws Exception {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ScmLogEntry entry = (ScmLogEntry)it.next();
            Iterator it2 = entry.getAction().iterator();
            while (it.hasNext()) {
                ScmLogEntryItem item = (ScmLogEntryItem)it2.next();
                switch (item.getActionType()) {
                    case 'A': {
                        ScmLogEntry.Add add = (ScmLogEntry.Add)item;
                        if (add.getPathType() == 'D') {
                            this.addDirectory("", add.getPath());
                            break;
                        }
                        int lastSlash = add.getPath().lastIndexOf(47);
                        String path = add.getPath().substring(0, lastSlash - 1);
                        String file = add.getPath().substring(lastSlash + 1, add.getPath().length() - 1);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        factory.getContent(path, file, -1L, bos);
                        ScmAction action = this.addFile(path, file, bos.toByteArray());
                        break;
                    }
                    case 'C': {
                        ScmAction action;
                        ScmLogEntry.Copy copy = (ScmLogEntry.Copy)item;
                        if (copy.getPathType() == 'D') {
                            action = this.copyDirectory(copy.getFromPath(), copy.getToPath(), copy.getFromRevision());
                            break;
                        }
                        int lastSlash = copy.getFromPath().lastIndexOf(47);
                        String fromPath = copy.getFromPath().substring(0, lastSlash - 1);
                        String fromFile = copy.getFromPath().substring(lastSlash + 1, copy.getFromPath().length() - 1);
                        lastSlash = copy.getToPath().lastIndexOf(47);
                        String toPath = copy.getToPath().substring(0, lastSlash - 1);
                        String toFile = copy.getToPath().substring(lastSlash + 1, copy.getToPath().length() - 1);
                        action = this.copyFile(fromPath, fromFile, toPath, toFile, copy.getFromRevision());
                        break;
                    }
                    case 'D': {
                        ScmAction action;
                        ScmLogEntry.Delete delete = (ScmLogEntry.Delete)item;
                        if (delete.getPathType() == 'D') {
                            action = this.deleteDirectory(delete.getPath());
                            break;
                        }
                        int lastSlash = delete.getPath().lastIndexOf(47);
                        String path = delete.getPath().substring(0, lastSlash - 1);
                        String file = delete.getPath().substring(lastSlash + 1, delete.getPath().length() - 1);
                        action = this.deleteFile(path, file);
                        break;
                    }
                    case 'U': {
                        ScmLogEntry.Update update = (ScmLogEntry.Update)item;
                        int lastSlash = update.getPath().lastIndexOf(47);
                        String path = update.getPath().substring(0, lastSlash - 1);
                        String file = update.getPath().substring(lastSlash + 1, update.getPath().length() - 1);
                        ByteArrayOutputStream bosOriginal = new ByteArrayOutputStream();
                        this.getContent(path, file, -1L, bosOriginal);
                        ByteArrayOutputStream bosNew = new ByteArrayOutputStream();
                        factory.getContent(path, file, update.getRevision(), bosNew);
                        ScmAction action = this.updateFile(path, file, bosOriginal.toByteArray(), bosNew.toByteArray());
                        break;
                    }
                }
            }
        }
    }

    private static String convertPath(String path, String token, String replace) {
        if (path.indexOf(token) == -1) {
            return path;
        }
        StringTokenizer tk = new StringTokenizer(path, token);
        StringBuffer buf = new StringBuffer();
        while (tk.hasMoreTokens()) {
            String el = tk.nextToken();
            buf.append(el);
            if (!tk.hasMoreTokens()) continue;
            buf.append(replace);
        }
        return buf.toString();
    }

    static String toDirectoryName(String packageName) {
        return JcrActionFactory.convertPath(packageName, ".", "/");
    }

    static String toPackageName(String directory) {
        return JcrActionFactory.convertPath(directory, "/", ".");
    }

    static String toFileName(AssetItem item) {
        return item.getName() + "." + item.getFormat();
    }

    public static class RepositoryContext {
        public RulesRepository repository;
        public String message;

        public RepositoryContext(RulesRepository repository2, String message2) {
            this.repository = repository2;
            this.message = message2;
        }
    }

    public static class DeleteDirectory
    implements ScmAction {
        private String path;

        public DeleteDirectory(String path) {
            this.path = path;
        }

        public void applyAction(Object context) throws Exception {
        }
    }

    public static class DeleteFile
    implements ScmAction {
        private String path;
        private String file;

        public DeleteFile(String path, String file) {
            this.path = path;
            this.file = file;
        }

        public void applyAction(Object context) throws Exception {
        }
    }

    public static class MoveDirectory
    implements ScmAction {
        private String path;
        private String newPath;
        private long revision;

        public MoveDirectory(String path, String newPath, long revision) {
            this.path = path;
            this.newPath = newPath;
            this.revision = revision;
        }

        public void applyAction(Object context) throws Exception {
        }
    }

    public static class MoveFile
    implements ScmAction {
        private String file;
        private String path;
        private String newPath;
        private String newFile;
        private long revision;

        public MoveFile(String path, String file, String newPath, String newFile, long revision) {
            this.path = path;
            this.file = file;
            this.newPath = newPath;
            this.newFile = newFile;
            this.revision = revision;
        }

        public void applyAction(Object context) throws Exception {
        }
    }

    public static class CopyDirectory
    implements ScmAction {
        private String path;
        private String newPath;
        private long revision;

        public CopyDirectory(String path, String newPath, long revision) {
            this.path = path;
            this.newPath = newPath;
            this.revision = revision;
        }

        public void applyAction(Object context) throws Exception {
        }
    }

    public static class CopyFile
    implements ScmAction {
        private String file;
        private String path;
        private String newPath;
        private String newFile;
        private long revision;

        public CopyFile(String path, String file, String newPath, String newFile, long revision) {
            this.path = path;
            this.file = file;
            this.newPath = newPath;
            this.newFile = newFile;
            this.revision = revision;
        }

        public void applyAction(Object context) throws Exception {
        }
    }

    public static class UpdateFile
    implements ScmAction {
        private String file;
        private String path;
        private byte[] oldContent;
        private byte[] newContent;

        public UpdateFile(String path, String file, byte[] oldContent, byte[] newContent) {
            this.path = path;
            this.file = file;
            this.oldContent = oldContent;
            this.newContent = newContent;
        }

        public void applyAction(Object context) throws Exception {
            RepositoryContext ctx = (RepositoryContext)context;
            PackageItem pkg = ctx.repository.loadPackage(JcrActionFactory.toPackageName(this.path));
            String name = this.file.substring(0, this.file.indexOf(46));
            AssetItem asset = pkg.loadAsset(name);
            asset.updateContent(new String(this.newContent));
            asset.checkin(ctx.message);
        }
    }

    public static class AddDirectory
    implements ScmAction {
        private String root;
        private String path;

        public AddDirectory(String root, String path) {
            this.root = root;
            this.path = path;
        }

        public void applyAction(Object context) throws Exception {
            PackageItem pkgItem;
            RepositoryContext ctx = (RepositoryContext)context;
            if (!this.root.equals("") && (pkgItem = ctx.repository.loadPackage(JcrActionFactory.toPackageName(this.root))) == null) {
                throw new RuntimeException("The parent package '" + this.root + "' must exist");
            }
            PackageItem item = ctx.repository.createPackage(JcrActionFactory.toPackageName(this.root + "/" + this.path), "initial package");
        }
    }

    public static class AddFile
    implements ScmAction {
        private String file;
        private String path;
        private byte[] content;

        public AddFile(String path, String file, byte[] content) {
            this.path = path;
            this.file = file;
            this.content = content;
        }

        public void applyAction(Object context) throws Exception {
            RepositoryContext ctx = (RepositoryContext)context;
            PackageItem pkg = ctx.repository.loadPackage(JcrActionFactory.toPackageName(this.path));
            StringTokenizer tk = new StringTokenizer(this.file, ".");
            String name = tk.nextToken();
            String format = tk.nextToken();
            AssetItem asset = pkg.addAsset(name, ctx.message);
            asset.updateFormat(format);
            asset.updateContent(new String(this.content));
        }
    }

    public static class PackagePathComparator
    implements Comparator {
        public int compare(Object object0, Object object1) {
            PackageItem item0 = (PackageItem)object0;
            PackageItem item1 = (PackageItem)object1;
            return item0.getName().compareTo(item1.getName());
        }
    }
}

