/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml;

import java.util.HashSet;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.Configuration;
import org.drools.xml.Handler;
import org.drools.xml.XmlPackageReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class RuleHandler
extends BaseAbstractHandler
implements Handler {
    RuleHandler(XmlPackageReader xmlPackageReader) {
        this.xmlPackageReader = xmlPackageReader;
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(PackageDescr.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(FunctionDescr.class);
            this.validPeers.add(RuleDescr.class);
            this.validPeers.add(QueryDescr.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs) throws SAXException {
        this.xmlPackageReader.startConfiguration(localName, attrs);
        String ruleName = attrs.getValue("name");
        if (ruleName == null || ruleName.trim().equals("")) {
            throw new SAXParseException("<rule> requires a 'name' attribute", this.xmlPackageReader.getLocator());
        }
        RuleDescr ruleDescr = new RuleDescr(ruleName.trim());
        return ruleDescr;
    }

    public Object end(String uri, String localName) throws SAXException {
        Configuration config = this.xmlPackageReader.endConfiguration();
        RuleDescr ruleDescr = (RuleDescr)this.xmlPackageReader.getCurrent();
        AndDescr lhs = ruleDescr.getLhs();
        if (lhs == null) {
            throw new SAXParseException("<rule> requires a LHS", this.xmlPackageReader.getLocator());
        }
        Configuration rhs = config.getChild("rhs");
        if (rhs == null) {
            throw new SAXParseException("<rule> requires a <rh> child element", this.xmlPackageReader.getLocator());
        }
        ruleDescr.setConsequence(rhs.getText());
        Configuration[] attributes = config.getChildren("rule-attribute");
        int length = attributes.length;
        for (int i = 0; i < length; ++i) {
            String name = attributes[i].getAttribute("name");
            if (name == null || name.trim().equals("")) {
                throw new SAXParseException("<rule-attribute> requires a 'name' attribute", this.xmlPackageReader.getLocator());
            }
            String value = attributes[i].getAttribute("value");
            ruleDescr.addAttribute(new AttributeDescr(name, value));
        }
        this.xmlPackageReader.getPackageDescr().addRule(ruleDescr);
        return null;
    }

    public Class generateNodeFor() {
        return RuleDescr.class;
    }
}

