/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.debug;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mvel.ASTIterator;
import org.mvel.ASTNode;
import org.mvel.CompiledExpression;
import org.mvel.ExecutableAccessor;
import org.mvel.ExecutableLiteral;
import org.mvel.ast.BinaryOperation;
import org.mvel.ast.NestedStatement;
import org.mvel.ast.Substatement;
import org.mvel.integration.VariableResolver;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ParseTools;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugTools {
    public static String decompile(Serializable expr) {
        if (expr instanceof CompiledExpression) {
            return DebugTools.decompile((CompiledExpression)expr);
        }
        if (expr instanceof ExecutableAccessor) {
            return "CANNOT DECOMPILE OPTIMIZED STATEMENT (Run with -Dmvel.optimizer=false)";
        }
        if (expr instanceof ExecutableLiteral) {
            return new StringBuffer("LITERAL: ").append(((ExecutableLiteral)expr).getValue(null, null)).toString();
        }
        return new StringBuffer("NOT A KNOWN PAYLOAD: ").append(expr.getClass().getName()).toString();
    }

    public static String decompile(CompiledExpression cExp) {
        return DebugTools.decompile(cExp, false, new DecompileContext());
    }

    private static String decompile(CompiledExpression cExp, boolean nest, DecompileContext context) {
        ASTIterator iter = cExp.getTokens();
        StringBuffer sbuf = new StringBuffer();
        if (!nest) {
            sbuf.append("Expression Decompile\n-------------\n");
        }
        while (iter.hasMoreNodes()) {
            ASTNode tk = iter.nextNode();
            sbuf.append("(").append(context.node++).append(") ");
            if (tk instanceof NestedStatement && ((NestedStatement)((Object)tk)).getNestedStatement() instanceof CompiledExpression) {
                sbuf.append(new StringBuffer("NEST [").append(ParseTools.getSimpleClassName(tk.getClass())).append("]: { ").append(tk.getName()).append(" }\n").toString());
                sbuf.append(DebugTools.decompile((CompiledExpression)((NestedStatement)((Object)tk)).getNestedStatement(), true, context));
            }
            if (tk instanceof Substatement && ((Substatement)tk).getStatement() instanceof CompiledExpression) {
                sbuf.append(new StringBuffer("NEST [").append(ParseTools.getSimpleClassName(tk.getClass())).append("]: { ").append(tk.getName()).append(" }\n").toString());
                sbuf.append(DebugTools.decompile((CompiledExpression)((Substatement)tk).getStatement(), true, context));
            } else if (tk.isDebuggingSymbol()) {
                sbuf.append(new StringBuffer("DEBUG_SYMBOL :: ").append(tk.toString()).toString());
            } else if (tk.isLiteral()) {
                sbuf.append("LITERAL :: ").append(tk.getLiteralValue()).append("'");
            } else if (tk.isOperator()) {
                sbuf.append("OPERATOR [").append(DebugTools.getOperatorName(tk.getOperator())).append("]: ").append(tk.getName());
                if (tk.isOperator(new Integer(37))) {
                    sbuf.append("\n");
                }
            } else if (tk.isIdentifier()) {
                sbuf.append("REFERENCE :: ").append(ParseTools.getSimpleClassName(tk.getClass())).append(":").append(tk.getName());
            } else if (tk instanceof BinaryOperation) {
                BinaryOperation bo = (BinaryOperation)tk;
                sbuf.append(new StringBuffer("OPERATION [").append(DebugTools.getOperatorName(bo.getOperation())).append("] {").toString()).append(bo.getLeft().getName()).append("} {").append(bo.getRight().getName()).append("}");
            } else {
                sbuf.append(new StringBuffer("NODE [").append(ParseTools.getSimpleClassName(tk.getClass())).append("] :: ").append(tk.getName()).toString());
            }
            sbuf.append("\n");
        }
        sbuf.append("==END==");
        return sbuf.toString();
    }

    public static String getOperatorName(int operator) {
        switch (operator) {
            case 0: {
                return "ADD";
            }
            case 1: {
                return "SUBTRACT";
            }
            case 31: {
                return "ASSIGN";
            }
            case 52: {
                return "ASSIGN_ADD";
            }
            case 54: {
                return "ASSIGN_STR_APPEND";
            }
            case 53: {
                return "ASSIGN_SUB";
            }
            case 6: {
                return "BIT_AND";
            }
            case 7: {
                return "BIT_OR";
            }
            case 10: {
                return "BIT_SHIFT_LEFT";
            }
            case 9: {
                return "BIT_SHIFT_RIGHT";
            }
            case 12: {
                return "BIT_UNSIGNED_SHIFT_LEFT";
            }
            case 11: {
                return "BIT_UNSIGNED_SHIFT_RIGHT";
            }
            case 8: {
                return "BIT_XOR";
            }
            case 25: {
                return "CONTAINS";
            }
            case 36: {
                return "CONVERTABLE_TO";
            }
            case 51: {
                return "DECREMENT";
            }
            case 33: {
                return "DECREMENT_ASSIGN";
            }
            case 3: {
                return "DIVIDE";
            }
            case 44: {
                return "DO";
            }
            case 40: {
                return "ELSE";
            }
            case 37: {
                return "END_OF_STATEMENT";
            }
            case 18: {
                return "EQUAL";
            }
            case 42: {
                return "FOR";
            }
            case 38: {
                return "FOREACH";
            }
            case 100: {
                return "FUNCTION";
            }
            case 17: {
                return "GREATER_THAN_OR_EQUAL";
            }
            case 15: {
                return "GREATHER_THAN";
            }
            case 39: {
                return "IF";
            }
            case 50: {
                return "INCREMENT";
            }
            case 32: {
                return "INCREMENT_ASSIGN";
            }
            case 24: {
                return "INSTANCEOF";
            }
            case 16: {
                return "LESS_THAN_OR_EQUAL";
            }
            case 14: {
                return "LESS_THAN";
            }
            case 4: {
                return "MODULUS";
            }
            case 2: {
                return "MULTIPLY";
            }
            case 19: {
                return "NOT_EQUAL";
            }
            case 34: {
                return "NEW_OBJECT";
            }
            case 21: {
                return "OR";
            }
            case 5: {
                return "POWER_OF";
            }
            case 35: {
                return "PROJECT";
            }
            case 23: {
                return "REGEX";
            }
            case 99: {
                return "RETURN";
            }
            case 28: {
                return "SIMILARITY";
            }
            case 27: {
                return "SOUNDEX";
            }
            case 26: {
                return "STR_APPEND";
            }
            case 43: {
                return "SWITCH";
            }
            case 29: {
                return "TERNARY_IF";
            }
            case 30: {
                return "TERNARY_ELSE";
            }
            case 41: {
                return "WHILE";
            }
            case 22: {
                return "CHAINED_OR";
            }
            case 200: {
                return "STK_SWAP";
            }
            case 201: {
                return "STK_XSWAP";
            }
        }
        return "UNKNOWN_OPERATOR";
    }

    public static Class determineType(String name, CompiledExpression compiledExpression) {
        ASTIterator iter = compiledExpression.getTokenIterator();
        while (iter.hasMoreNodes()) {
            ASTNode node = iter.nextNode();
            if (!name.equals(node.getName()) || !node.isAssignment()) continue;
            return node.getEgressType();
        }
        return null;
    }

    public static Map<String, VariableResolver> getAllVariableResolvers(VariableResolverFactory rootFactory) {
        HashMap<String, VariableResolver> allVariableResolvers = new HashMap<String, VariableResolver>();
        VariableResolverFactory vrf = rootFactory;
        do {
            for (String var : vrf.getKnownVariables()) {
                allVariableResolvers.put(var, vrf.getVariableResolver(var));
            }
        } while ((vrf = vrf.getNextFactory()) != null);
        return allVariableResolvers;
    }

    private static final class DecompileContext {
        public int node = 0;

        private DecompileContext() {
        }
    }
}

