/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.validation.handler;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.jbi.messaging.MessagingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.validation.handler.MessageAwareErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MessageAggregatingErrorHandler
implements MessageAwareErrorHandler {
    private static final String OPEN_CDATA = "<![CDATA[";
    private static final String CLOSE_CDATA = "]]>";
    private static final String OPEN_ERROR = "<error>";
    private static final String CLOSE_ERROR = "</error>";
    private static final String OPEN_FATAL = "<fatalError>";
    private static final String CLOSE_FATAL = "</fatalError>";
    private static final String OPEN_WARNING = "<warning>";
    private static final String CLOSE_WARNING = "</warning>";
    private String openRootElement;
    private String closeRootElement;
    private int warningCount;
    private int errorCount;
    private int fatalErrorCount;
    private String rootPath;
    private String namespace;
    private boolean includeStackTraces;
    private StringBuffer messages = new StringBuffer();
    private SourceTransformer sourceTransformer = new SourceTransformer();

    public MessageAggregatingErrorHandler(String rootPath, String namespace, boolean includeStackTraces) throws IllegalArgumentException {
        if (rootPath == null || rootPath.trim().length() == 0) {
            throw new IllegalArgumentException("rootPath must not be null or an empty string");
        }
        this.rootPath = rootPath;
        this.namespace = namespace;
        this.includeStackTraces = includeStackTraces;
        this.createRootElementTags();
    }

    private void createRootElementTags() {
        String[] pathElements = this.rootPath.split("/");
        StringBuffer openRootElementSB = new StringBuffer().append("<").append(pathElements[0]);
        StringBuffer closeRootElementSB = new StringBuffer();
        if (this.namespace != null && this.namespace.trim().length() > 0) {
            openRootElementSB.append(" xmlns=\"").append(this.namespace).append("\">");
        } else {
            openRootElementSB.append(">");
        }
        if (pathElements.length > 0) {
            int j = pathElements.length - 1;
            int i = 1;
            while (i < pathElements.length) {
                openRootElementSB.append("<").append(pathElements[i]).append(">");
                closeRootElementSB.append("</").append(pathElements[j]).append(">");
                ++i;
                --j;
            }
        }
        closeRootElementSB.append("</").append(pathElements[0]).append(">");
        this.openRootElement = openRootElementSB.toString();
        this.closeRootElement = closeRootElementSB.toString();
    }

    public boolean hasErrors() {
        return this.getErrorCount() > 0 || this.getFatalErrorCount() > 0;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getFatalErrorCount() {
        return this.fatalErrorCount;
    }

    public void warning(SAXParseException e) throws SAXException {
        ++this.warningCount;
        this.messages.append(OPEN_WARNING).append(OPEN_CDATA);
        this.appendErrorMessage(e);
        this.messages.append(CLOSE_CDATA).append(CLOSE_WARNING);
    }

    public void error(SAXParseException e) throws SAXException {
        ++this.errorCount;
        this.messages.append(OPEN_ERROR).append(OPEN_CDATA);
        this.appendErrorMessage(e);
        this.messages.append(CLOSE_CDATA).append(CLOSE_ERROR);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        ++this.fatalErrorCount;
        this.messages.append(OPEN_FATAL).append(OPEN_CDATA);
        this.appendErrorMessage(e);
        this.messages.append(CLOSE_CDATA).append(CLOSE_FATAL);
    }

    private void appendErrorMessage(SAXParseException e) {
        if (this.includeStackTraces) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.messages.append(sw.toString());
        } else {
            this.messages.append(e.getLocalizedMessage());
        }
    }

    public boolean capturesMessages() {
        return true;
    }

    public Object getMessagesAs(Class format) throws MessagingException {
        if (format == DOMSource.class) {
            return this.getDOMSource();
        }
        if (format == StringSource.class) {
            return this.getStringSource();
        }
        if (format == String.class) {
            return this.getMessagesWithRootElement();
        }
        throw new MessagingException("Unsupported message format: " + format.getName());
    }

    public boolean supportsMessageFormat(Class format) {
        if (format == DOMSource.class) {
            return true;
        }
        if (format == StringSource.class) {
            return true;
        }
        return format == String.class;
    }

    private String getMessagesWithRootElement() {
        return new StringBuffer().append(this.openRootElement).append(this.messages).append(this.closeRootElement).toString();
    }

    private StringSource getStringSource() {
        return new StringSource(this.getMessagesWithRootElement());
    }

    private DOMSource getDOMSource() throws MessagingException {
        try {
            return this.sourceTransformer.toDOMSource((Source)this.getStringSource());
        }
        catch (ParserConfigurationException e) {
            throw new MessagingException("Failed to create DOMSource for Schema validation messages: " + e, (Throwable)e);
        }
        catch (IOException e) {
            throw new MessagingException("Failed to create DOMSource for Schema validation messages: " + e, (Throwable)e);
        }
        catch (SAXException e) {
            throw new MessagingException("Failed to create DOMSource for Schema validation messages: " + e, (Throwable)e);
        }
        catch (TransformerException e) {
            throw new MessagingException("Failed to create DOMSource for Schema validation messages: " + e, (Throwable)e);
        }
    }
}

