/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jbi.JBIException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.deployer.ServiceAssembly;
import org.apache.servicemix.jbi.deployer.ServiceUnit;
import org.apache.servicemix.jbi.deployer.descriptor.ServiceAssemblyDesc;
import org.apache.servicemix.jbi.deployer.impl.ServiceUnitImpl;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceAssemblyImpl
implements ServiceAssembly {
    private static final Log LOGGER = LogFactory.getLog(ServiceAssemblyImpl.class);
    private static final String STATE = "state";
    private ServiceAssemblyDesc serviceAssemblyDesc;
    private List<ServiceUnitImpl> serviceUnits;
    private State state = State.Unknown;
    private Preferences prefs;
    private State runningState;

    public ServiceAssemblyImpl(ServiceAssemblyDesc serviceAssemblyDesc, List<ServiceUnitImpl> serviceUnits, Preferences prefs, boolean autoStart) {
        this.serviceAssemblyDesc = serviceAssemblyDesc;
        this.serviceUnits = serviceUnits;
        this.prefs = prefs;
        this.runningState = State.valueOf(this.prefs.get(STATE, (autoStart ? State.Started : State.Initialized).name()));
        for (ServiceUnitImpl su : serviceUnits) {
            su.setServiceAssemblyImpl(this);
        }
    }

    @Override
    public String getName() {
        return this.serviceAssemblyDesc.getIdentification().getName();
    }

    @Override
    public String getDescription() {
        return this.serviceAssemblyDesc.getIdentification().getDescription();
    }

    @Override
    public ServiceUnit[] getServiceUnits() {
        return this.serviceUnits.toArray(new ServiceUnit[this.serviceUnits.size()]);
    }

    public State getState() {
        return this.state;
    }

    public String getCurrentState() {
        switch (this.state) {
            case Started: {
                return "Started";
            }
            case Stopped: {
                return "Stopped";
            }
            case Initialized: 
            case Shutdown: {
                return "Shutdown";
            }
        }
        return "Unknown";
    }

    public void init() throws JBIException {
        this.transition(State.Initialized);
        if (this.runningState == State.Started) {
            this.transition(State.Started);
        } else if (this.runningState == State.Stopped) {
            this.transition(State.Started);
            this.transition(State.Stopped);
        } else if (this.runningState == State.Shutdown) {
            this.transition(State.Shutdown);
        }
    }

    public void start() throws JBIException {
        this.start(true);
    }

    public void start(boolean persist) throws JBIException {
        this.transition(State.Started);
        if (persist) {
            this.saveState();
        }
    }

    public void stop() throws JBIException {
        this.stop(true);
    }

    public void stop(boolean persist) throws JBIException {
        this.transition(State.Stopped);
        if (persist) {
            this.saveState();
        }
    }

    public void shutDown() throws JBIException {
        this.shutDown(true);
    }

    public void shutDown(boolean persist) throws JBIException {
        this.transition(State.Shutdown);
        if (persist) {
            this.saveState();
        }
    }

    private void saveState() {
        this.prefs.put(STATE, this.state.name());
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException e) {
            LOGGER.warn((Object)"Unable to persist state", (Throwable)e);
        }
    }

    protected void transition(State to) throws JBIException {
        LOGGER.info((Object)("Changing SA state to " + (Object)((Object)to)));
        State from = this.state;
        ArrayList<ServiceUnitImpl> success = new ArrayList<ServiceUnitImpl>();
        for (ServiceUnitImpl su : this.serviceUnits) {
            try {
                this.changeState(su, to);
                success.add(su);
            }
            catch (JBIException e) {
                if (from != State.Unknown) {
                    for (ServiceUnitImpl su2 : success) {
                        try {
                            this.changeState(su2, from);
                        }
                        catch (JBIException e2) {}
                    }
                }
                throw e;
            }
        }
        this.state = to;
    }

    protected void changeState(ServiceUnitImpl su, State state) throws JBIException {
        switch (state) {
            case Initialized: {
                su.init();
                break;
            }
            case Started: {
                su.start();
                break;
            }
            case Stopped: {
                su.stop();
                break;
            }
            case Shutdown: {
                su.shutdown();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        Unknown,
        Initialized,
        Started,
        Stopped,
        Shutdown;

    }
}

