/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform.stream;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import javax.xml.transform.Result;

public class StreamResult
implements Result {
    public static final String FEATURE = "http://javax.xml.transform.stream.StreamResult/feature";
    private String systemId;
    private OutputStream outputStream;
    private Writer writer;

    public StreamResult() {
    }

    public StreamResult(OutputStream outputStream) {
        this.setOutputStream(outputStream);
    }

    public StreamResult(Writer writer) {
        this.setWriter(writer);
    }

    public StreamResult(String systemId) {
        this.systemId = systemId;
    }

    public StreamResult(File f) {
        this.setSystemId(f);
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setSystemId(File f) {
        try {
            Method toURIMethod = f.getClass().getMethod("toURI", null);
            Object uri = toURIMethod.invoke((Object)f, (Object[])null);
            Method toStringMethod = uri.getClass().getMethod("toString", null);
            this.systemId = (String)toStringMethod.invoke(uri, (Object[])null);
        }
        catch (Exception exception) {
            try {
                this.systemId = f.toURL().toString();
            }
            catch (MalformedURLException malformedURLException) {
                this.systemId = null;
                throw new RuntimeException("javax.xml.transform.stream.StreamResult#setSystemId(File f) with MalformedURLException: " + malformedURLException.toString());
            }
        }
    }

    public String getSystemId() {
        return this.systemId;
    }
}

