/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import org.xml.sax.helpers.SecuritySupport;

class NewInstance {
    private static final boolean DO_FALLBACK = true;

    NewInstance() {
    }

    static Object newInstance(ClassLoader classLoader, String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> driverClass;
        if (classLoader == null) {
            driverClass = Class.forName(className);
        } else {
            try {
                driverClass = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException x) {
                classLoader = NewInstance.class.getClassLoader();
                driverClass = classLoader != null ? classLoader.loadClass(className) : Class.forName(className);
            }
        }
        Object instance = driverClass.newInstance();
        return instance;
    }

    static ClassLoader getClassLoader() {
        ClassLoader cl = SecuritySupport.getContextClassLoader();
        if (cl == null) {
            cl = NewInstance.class.getClassLoader();
        }
        return cl;
    }
}

