/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.WebFault;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.FaultOutInterceptor;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebFaultOutInterceptor
extends FaultOutInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(WebFaultOutInterceptor.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(WebFaultOutInterceptor.class);

    private QName getFaultName(WebFault wf, Class<?> cls, OperationInfo op) {
        String name;
        String ns = wf.targetNamespace();
        if (StringUtils.isEmpty(ns)) {
            ns = op.getName().getNamespaceURI();
        }
        if (StringUtils.isEmpty(name = wf.name())) {
            name = cls.getSimpleName();
        }
        return new QName(ns, name);
    }

    private WebFault getWebFaultAnnotation(Class<?> t) {
        WebFault fault = t.getAnnotation(WebFault.class);
        if (fault == null && t.getSuperclass() != null && Throwable.class.isAssignableFrom(t.getSuperclass())) {
            fault = this.getWebFaultAnnotation(t.getSuperclass());
        }
        return fault;
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        Fault f = (Fault)message.getContent(Exception.class);
        Throwable cause = f.getCause();
        WebFault fault = null;
        if (cause != null) {
            fault = this.getWebFaultAnnotation(cause.getClass());
        }
        if (cause instanceof Exception && fault != null) {
            Exception ex = (Exception)cause;
            Object faultInfo = null;
            try {
                Method method = cause.getClass().getMethod("getFaultInfo", new Class[0]);
                faultInfo = method.invoke((Object)cause, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                faultInfo = this.createFaultInfoBean(fault, cause);
            }
            catch (InvocationTargetException e) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("INVOCATION_TARGET_EXC", BUNDLE, new Object[0]), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("COULD_NOT_INVOKE", BUNDLE, new Object[0]), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("COULD_NOT_INVOKE", BUNDLE, new Object[0]), (Throwable)e);
            }
            Service service = message.getExchange().get(Service.class);
            try {
                DataWriter<Node> writer = service.getDataBinding().createWriter(Node.class);
                OperationInfo op = message.getExchange().get(BindingOperationInfo.class).getOperationInfo();
                QName faultName = this.getFaultName(fault, cause.getClass(), op);
                MessagePartInfo part = this.getFaultMessagePart(faultName, op);
                writer.write(faultInfo, part, f.getOrCreateDetail());
                f.setMessage(ex.getMessage());
            }
            catch (Exception nex) {
                LOG.log(Level.WARNING, "EXCEPTION_WHILE_WRITING_FAULT", nex);
            }
        } else {
            FaultMode mode = message.get(FaultMode.class);
            if (mode == FaultMode.CHECKED_APPLICATION_FAULT) {
                super.handleMessage(message);
            }
        }
    }

    private Object createFaultInfoBean(WebFault fault, Throwable cause) {
        if (!StringUtils.isEmpty(fault.faultBean())) {
            try {
                Class<?> cls = ClassLoaderUtils.loadClass(fault.faultBean(), cause.getClass());
                if (cls != null) {
                    Method[] meth;
                    Object ret = cls.newInstance();
                    for (Method m : meth = cause.getClass().getMethods()) {
                        if (m.getParameterTypes().length != 0 || !m.getName().startsWith("get") && !m.getName().startsWith("is")) continue;
                        try {
                            String name = m.getName().startsWith("get") ? "set" + m.getName().substring(3) : "set" + m.getName().substring(2);
                            Method m2 = cls.getMethod(name, m.getReturnType());
                            m2.invoke(ret, m.invoke((Object)cause, new Object[0]));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    return ret;
                }
            }
            catch (ClassNotFoundException e1) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        LOG.fine("Using @WebFault annotated class " + cause.getClass().getName() + " as faultInfo since getFaultInfo() was not found");
        return cause;
    }

    private MessagePartInfo getFaultMessagePart(QName qname, OperationInfo op) {
        for (FaultInfo faultInfo : op.getFaults()) {
            for (MessagePartInfo mpi : faultInfo.getMessageParts()) {
                String ns = null;
                ns = mpi.isElement() ? mpi.getElementQName().getNamespaceURI() : mpi.getTypeQName().getNamespaceURI();
                if (!qname.getLocalPart().equals(mpi.getConcreteName().getLocalPart()) || !qname.getNamespaceURI().equals(ns)) continue;
                return mpi;
            }
        }
        return null;
    }
}

