/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.common.toolspec.parser.Option;
import org.apache.cxf.tools.common.toolspec.parser.TokenConsumer;
import org.apache.cxf.tools.common.toolspec.parser.TokenInputStream;
import org.w3c.dom.Element;

public class OptionGroup
implements TokenConsumer {
    private static final Logger LOG = LogUtils.getL7dLogger(OptionGroup.class);
    private final Element element;
    private final List<Object> options = new ArrayList<Object>();

    public OptionGroup(Element el) {
        this.element = el;
        List<Element> optionEls = DOMUtils.findAllElementsByTagNameNS(this.element, "http://cxf.apache.org/Xutil/ToolSpecification", "option");
        for (Element elem : optionEls) {
            this.options.add(new Option(elem));
        }
    }

    public boolean accept(TokenInputStream args, Element result, ErrorVisitor errors) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Accepting token stream for optionGroup: " + this + ", tokens are now " + args + ", running through " + this.options.size() + " options");
        }
        boolean accepted = false;
        for (Option option : this.options) {
            if (!option.accept(args, result, errors)) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Option " + option + " accepted the token");
            }
            accepted = true;
            break;
        }
        if (!accepted) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("No option accepted the token, returning");
            }
            return false;
        }
        return true;
    }

    public boolean isSatisfied(ErrorVisitor errors) {
        Iterator<Object> it = this.options.iterator();
        while (it.hasNext()) {
            if (((Option)it.next()).isSatisfied(errors)) continue;
            return false;
        }
        return true;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public String toString() {
        if (this.element.hasAttribute("id")) {
            return this.getId();
        }
        return super.toString();
    }
}

