/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import javax.jms.ConnectionFactory;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.configuration.ConfigurationException;
import org.apache.cxf.transport.jms.JMSFactory;
import org.apache.cxf.transport.jms.JNDIConfiguration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.connection.SingleConnectionFactory;
import org.springframework.jms.connection.SingleConnectionFactory102;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jndi.JndiTemplate;
import org.springframework.transaction.PlatformTransactionManager;

public class JMSConfiguration
implements InitializingBean {
    public static final int DEFAULT_VALUE = -1;
    static final boolean DEFAULT_USEJMS11 = false;
    private boolean usingEndpointInfo = true;
    private JndiTemplate jndiTemplate;
    private ConnectionFactory connectionFactory;
    private DestinationResolver destinationResolver;
    private PlatformTransactionManager transactionManager;
    private boolean wrapInSingleConnectionFactory = true;
    private TaskExecutor taskExecutor;
    private boolean useJms11 = false;
    private boolean reconnectOnException;
    private boolean messageIdEnabled = true;
    private boolean messageTimestampEnabled = true;
    private boolean pubSubNoLocal;
    private long receiveTimeout;
    private boolean explicitQosEnabled;
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    private boolean sessionTransacted;
    private int concurrentConsumers = 1;
    private int maxConcurrentConsumers = 1;
    private int maxConcurrentTasks = 10;
    private volatile String messageSelector;
    private boolean subscriptionDurable;
    private String durableSubscriptionClientId;
    private String durableSubscriptionName;
    private String targetDestination;
    private String replyDestination;
    private String messageType = "text";
    private boolean pubSubDomain;
    private boolean useConduitIdSelector = true;
    private String conduitSelectorPrefix = "";
    private boolean autoResolveDestination;
    private long recoveryInterval = -1L;
    private int cacheLevel = -1;
    private String cacheLevelName;
    private ConnectionFactory wrappedConnectionFactory;
    private JNDIConfiguration jndiConfig;

    public void ensureProperlyConfigured(Message msg) {
        if (this.targetDestination == null || this.getOrCreateWrappedConnectionFactory() == null) {
            throw new ConfigurationException(msg);
        }
    }

    public String getCacheLevelName() {
        return this.cacheLevelName;
    }

    public void setCacheLevelName(String cacheLevelName) {
        this.cacheLevelName = cacheLevelName;
    }

    public int getCacheLevel() {
        return this.cacheLevel;
    }

    public void setCacheLevel(int cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public long getRecoveryInterval() {
        return this.recoveryInterval;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public boolean isAutoResolveDestination() {
        return this.autoResolveDestination;
    }

    public void setAutoResolveDestination(boolean autoResolveDestination) {
        this.autoResolveDestination = autoResolveDestination;
    }

    public boolean isUsingEndpointInfo() {
        return this.usingEndpointInfo;
    }

    public void setUsingEndpointInfo(boolean usingEndpointInfo) {
        this.usingEndpointInfo = usingEndpointInfo;
    }

    public boolean isMessageIdEnabled() {
        return this.messageIdEnabled;
    }

    public void setMessageIdEnabled(boolean messageIdEnabled) {
        this.messageIdEnabled = messageIdEnabled;
    }

    public boolean isMessageTimestampEnabled() {
        return this.messageTimestampEnabled;
    }

    public void setMessageTimestampEnabled(boolean messageTimestampEnabled) {
        this.messageTimestampEnabled = messageTimestampEnabled;
    }

    public boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public boolean isExplicitQosEnabled() {
        return this.explicitQosEnabled;
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.explicitQosEnabled = explicitQosEnabled;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public void setConduitSelectorPrefix(String conduitSelectorPrefix) {
        this.conduitSelectorPrefix = conduitSelectorPrefix;
    }

    public String getConduitSelectorPrefix() {
        return this.conduitSelectorPrefix;
    }

    public boolean isSubscriptionDurable() {
        return this.subscriptionDurable;
    }

    public void setSubscriptionDurable(boolean subscriptionDurable) {
        this.subscriptionDurable = subscriptionDurable;
    }

    public String getDurableSubscriptionName() {
        return this.durableSubscriptionName;
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.durableSubscriptionName = durableSubscriptionName;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.connectionFactory == null) {
            throw new RuntimeException("Required property connectionfactory was not set");
        }
    }

    @Required
    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getTargetDestination() {
        return this.targetDestination;
    }

    public void setTargetDestination(String targetDestination) {
        this.targetDestination = targetDestination;
    }

    public String getReplyDestination() {
        return this.replyDestination;
    }

    public void setReplyDestination(String replyDestination) {
        this.replyDestination = replyDestination;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    public void setPubSubDomain(boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
    }

    public boolean isUseJms11() {
        return this.useJms11;
    }

    public void setUseJms11(boolean useJms11) {
        this.useJms11 = useJms11;
    }

    public DestinationResolver getDestinationResolver() {
        return this.destinationResolver;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    public boolean isSessionTransacted() {
        return this.sessionTransacted;
    }

    public void setSessionTransacted(boolean sessionTransacted) {
        this.sessionTransacted = sessionTransacted;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public int getMaxConcurrentConsumers() {
        return this.maxConcurrentConsumers;
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.maxConcurrentConsumers = maxConcurrentConsumers;
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setUseConduitIdSelector(boolean useConduitIdSelector) {
        this.useConduitIdSelector = useConduitIdSelector;
    }

    public boolean isUseConduitIdSelector() {
        return this.useConduitIdSelector;
    }

    public int getMaxConcurrentTasks() {
        return this.maxConcurrentTasks;
    }

    public void setMaxConcurrentTasks(int maxConcurrentTasks) {
        this.maxConcurrentTasks = maxConcurrentTasks;
    }

    public void setJndiTemplate(JndiTemplate jndiTemplate) {
        this.jndiTemplate = jndiTemplate;
    }

    public JndiTemplate getJndiTemplate() {
        return this.jndiTemplate;
    }

    public JNDIConfiguration getJndiConfig() {
        return this.jndiConfig;
    }

    public void setJndiConfig(JNDIConfiguration jndiConfig) {
        this.jndiConfig = jndiConfig;
    }

    public boolean isReconnectOnException() {
        return this.reconnectOnException;
    }

    public void setReconnectOnException(boolean reconnectOnException) {
        this.reconnectOnException = reconnectOnException;
    }

    public ConnectionFactory getOrCreateWrappedConnectionFactory() {
        if (this.wrappedConnectionFactory == null) {
            if (this.connectionFactory == null) {
                this.connectionFactory = JMSFactory.getConnectionFactoryFromJndi(this);
            }
            if (this.wrapInSingleConnectionFactory && !(this.connectionFactory instanceof SingleConnectionFactory)) {
                Object scf = this.useJms11 ? new SingleConnectionFactory(this.connectionFactory) : new SingleConnectionFactory102(this.connectionFactory, this.pubSubDomain);
                if (this.getDurableSubscriptionClientId() != null) {
                    scf.setClientId(this.getDurableSubscriptionClientId());
                }
                scf.setReconnectOnException(this.isReconnectOnException());
                this.wrappedConnectionFactory = scf;
            } else {
                this.wrappedConnectionFactory = this.connectionFactory;
            }
        }
        return this.wrappedConnectionFactory;
    }

    protected ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public boolean isWrapInSingleConnectionFactory() {
        return this.wrapInSingleConnectionFactory;
    }

    public void setWrapInSingleConnectionFactory(boolean wrapInSingleConnectionFactory) {
        this.wrapInSingleConnectionFactory = wrapInSingleConnectionFactory;
    }

    public String getDurableSubscriptionClientId() {
        return this.durableSubscriptionClientId;
    }

    public void setDurableSubscriptionClientId(String durableSubscriptionClientId) {
        this.durableSubscriptionClientId = durableSubscriptionClientId;
    }
}

