/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.commands;

import java.util.List;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.servicemix.jbi.commands.JbiCommandSupport;
import org.apache.servicemix.jbi.deployer.Component;
import org.apache.servicemix.jbi.deployer.ServiceAssembly;
import org.apache.servicemix.jbi.deployer.SharedLibrary;

@CommandComponent(id="jbi:list", description="List deployed JBI artifacts")
public class ListCommand
extends JbiCommandSupport {
    protected Object doExecute() throws Exception {
        List<ServiceAssembly> assemblies;
        List<Component> components;
        List<SharedLibrary> libraries = this.getSharedLibraries();
        if (libraries != null && !libraries.isEmpty()) {
            this.io.out.println("Shared Libraries");
            this.io.out.println("----------------");
            for (SharedLibrary library : libraries) {
                this.io.out.println(library.getName() + " - " + library.getVersion() + " - " + library.getDescription());
            }
            this.io.out.println();
        }
        if ((components = this.getComponents()) != null && !components.isEmpty()) {
            this.io.out.println("Components");
            this.io.out.println("----------");
            for (Component component : components) {
                this.io.out.println(component.getName() + " - " + component.getCurrentState() + " - " + component.getDescription());
            }
            this.io.out.println();
        }
        if ((assemblies = this.getServiceAssemblies()) != null && !assemblies.isEmpty()) {
            this.io.out.println("Service Assemblies");
            this.io.out.println("------------------");
            for (ServiceAssembly assembly : assemblies) {
                this.io.out.println(assembly.getName() + " - " + assembly.getCurrentState() + " - " + assembly.getDescription());
            }
            this.io.out.println();
        }
        return null;
    }
}

