/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.springframework.util.Assert;

public class ChainedExceptionListener
implements ExceptionListener {
    private final List delegates = new ArrayList(2);

    public final void addDelegate(ExceptionListener listener) {
        Assert.notNull((Object)listener, (String)"ExceptionListener must not be null");
        this.delegates.add(listener);
    }

    public final ExceptionListener[] getDelegates() {
        return this.delegates.toArray(new ExceptionListener[this.delegates.size()]);
    }

    public void onException(JMSException ex) {
        Iterator it = this.delegates.iterator();
        while (it.hasNext()) {
            ExceptionListener listener = (ExceptionListener)it.next();
            listener.onException(ex);
        }
    }
}

