/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.compendium.internal;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.util.internal.MapBasedDictionary;
import org.springframework.util.Assert;

public class OsgiPropertyPlaceholder
extends PropertyPlaceholderConfigurer
implements BundleContextAware,
InitializingBean {
    private String persistentId;
    private BundleContext bundleContext;
    private Properties cmProperties;

    public String getPersistentId() {
        return this.persistentId;
    }

    public void setPersistentId(String persistentId) {
        this.persistentId = persistentId;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.persistentId, (String)"peristentId property is required");
        Assert.notNull((Object)this.bundleContext, (String)"bundleContext property is required");
        ConfigurationAdmin admin = this.retrieveConfigurationAdmin(this.bundleContext);
        Configuration config = admin.getConfiguration(this.persistentId);
        this.cmProperties = new Properties();
        Dictionary dict = config.getProperties();
        if (dict == null) {
            dict = new MapBasedDictionary();
        }
        Enumeration keys = dict.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            this.cmProperties.put(key, dict.get(key));
        }
    }

    protected Properties mergeProperties() throws IOException {
        Properties prop = new Properties(super.mergeProperties());
        if (this.cmProperties != null) {
            prop.putAll((Map<?, ?>)this.cmProperties);
        }
        return prop;
    }

    protected ConfigurationAdmin retrieveConfigurationAdmin(BundleContext bundleContext) {
        ServiceReference adminRef = bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        Assert.notNull((Object)adminRef, (String)"ConfigurationAdmin service reference could not be found");
        Object service = bundleContext.getService(adminRef);
        Assert.notNull((Object)service, (String)"ConfigurationAdmin Service could not be found");
        Assert.isInstanceOf((Class)ConfigurationAdmin.class, (Object)service, (String)("service " + service + " is not an instance of " + ConfigurationAdmin.class.getName()));
        return (ConfigurationAdmin)service;
    }

    public void setBundleContext(BundleContext context) {
        this.bundleContext = context;
    }
}

