/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.dependency.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.CollectionFactory;
import org.springframework.core.ConcurrentMap;
import org.springframework.osgi.service.dependency.internal.MandatoryServiceDependencyManager;
import org.springframework.osgi.service.exporter.support.internal.controller.ExporterControllerUtils;
import org.springframework.osgi.service.exporter.support.internal.controller.ExporterInternalActions;
import org.springframework.osgi.service.importer.OsgiServiceDependency;
import org.springframework.osgi.service.importer.support.OsgiServiceCollectionProxyFactoryBean;
import org.springframework.osgi.service.importer.support.OsgiServiceProxyFactoryBean;
import org.springframework.osgi.service.importer.support.internal.controller.ImporterControllerUtils;
import org.springframework.osgi.service.importer.support.internal.controller.ImporterInternalActions;
import org.springframework.osgi.service.importer.support.internal.dependency.ImporterStateListener;
import org.springframework.osgi.util.internal.BeanFactoryUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DefaultMandatoryDependencyManager
implements MandatoryServiceDependencyManager,
BeanFactoryAware,
DisposableBean {
    private static final Log log = LogFactory.getLog((Class)DefaultMandatoryDependencyManager.class);
    private final ConcurrentMap exportersSeen = CollectionFactory.createConcurrentMap((int)4);
    private static final Object VALUE = new Object();
    private final Map exporterToImporterDeps = CollectionFactory.createConcurrentMap((int)8);
    private final Map exporterListener = CollectionFactory.createConcurrentMap((int)8);
    private final ConcurrentMap importerToName = CollectionFactory.createConcurrentMap((int)8);
    private final Map exporterToName = CollectionFactory.createConcurrentMap((int)8);
    private ConfigurableListableBeanFactory beanFactory;

    public void addServiceExporter(Object exporter, String exporterBeanName) {
        Assert.hasText((String)exporterBeanName);
        if (this.exportersSeen.putIfAbsent((Object)exporterBeanName, VALUE) == null) {
            String beanName = exporterBeanName;
            if (this.beanFactory.isFactoryBean(exporterBeanName)) {
                beanName = "&" + exporterBeanName;
            }
            if (!this.beanFactory.isSingleton(beanName)) {
                log.info((Object)("Exporter [" + beanName + "] is not singleton and will not be tracked"));
            } else {
                this.exporterToName.put(exporter, exporterBeanName);
                ExporterInternalActions controller = ExporterControllerUtils.getControllerFor(exporter);
                controller.registerServiceAtStartup(false);
                this.discoverDependentImporterFor(exporterBeanName, exporter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discoverDependentImporterFor(String exporterBeanName, Object exporter) {
        boolean trace = log.isTraceEnabled();
        String[] importerA = BeanFactoryUtils.getTransitiveDependenciesForBean(this.beanFactory, exporterBeanName, true, OsgiServiceProxyFactoryBean.class);
        String[] importerB = BeanFactoryUtils.getTransitiveDependenciesForBean(this.beanFactory, exporterBeanName, true, OsgiServiceCollectionProxyFactoryBean.class);
        Object[] importerNames = StringUtils.concatenateStringArrays((String[])importerA, (String[])importerB);
        LinkedHashMap<Object, Object> dependingImporters = new LinkedHashMap<Object, Object>(importerNames.length);
        if (trace) {
            log.trace((Object)("Exporter [" + exporterBeanName + "] depends (transitively) on the following importers:" + ObjectUtils.nullSafeToString((Object[])importerNames)));
        }
        ImporterDependencyListener listener = new ImporterDependencyListener(exporter);
        this.exporterListener.put(exporter, listener);
        for (int i = 0; i < importerNames.length; ++i) {
            if (this.beanFactory.isSingleton((String)importerNames[i])) {
                Object importer = this.beanFactory.getBean((String)importerNames[i]);
                if (this.isSatisfied(importer)) {
                    dependingImporters.put(importer, importerNames[i]);
                    this.importerToName.putIfAbsent(importer, importerNames[i]);
                    continue;
                }
                if (!trace) continue;
                log.trace((Object)("Importer [" + (String)importerNames[i] + "] is optional; skipping it"));
                continue;
            }
            if (!trace) continue;
            log.trace((Object)("Importer [" + (String)importerNames[i] + "] is a non-singleton; ignoring it"));
        }
        if (trace) {
            log.trace((Object)("After filtering, exporter [" + exporterBeanName + "] depends on importers:" + dependingImporters.values()));
        }
        Set filteredImporters = dependingImporters.keySet();
        Object object = exporter;
        synchronized (object) {
            LinkedHashMap importerStatuses = new LinkedHashMap(filteredImporters.size());
            Iterator iter = filteredImporters.iterator();
            while (iter.hasNext()) {
                Object importer = iter.next();
                importerStatuses.put(importer, this.isSatisfied(importer));
                this.addListener(importer, listener);
            }
            this.exporterToImporterDeps.put(exporter, importerStatuses);
            this.checkIfExporterShouldStart(exporter, importerStatuses);
        }
    }

    private void checkIfExporterShouldStart(Object exporter, Map importers) {
        if (!importers.containsValue(Boolean.FALSE)) {
            this.startExporter(exporter);
            if (log.isDebugEnabled()) {
                log.trace((Object)("Exporter [" + this.exporterToName.get(exporter) + "] started; all its dependencies are satisfied"));
            }
        } else {
            ArrayList<Object> unsatisfiedDependencies = new ArrayList<Object>(importers.size());
            Iterator iterator = importers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!Boolean.FALSE.equals(entry.getValue())) continue;
                unsatisfiedDependencies.add(this.importerToName.get(entry.getKey()));
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Exporter [" + this.exporterToName.get(exporter) + "] not started; there are still has unsatisfied dependencies " + unsatisfiedDependencies));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceExporter(Object bean, String beanName) {
        this.exporterToName.remove(bean);
        Map importers = (Map)this.exporterToImporterDeps.remove(bean);
        ImporterStateListener stateListener = (ImporterStateListener)this.exporterListener.remove(bean);
        Object object = bean;
        synchronized (object) {
            Iterator iterator = importers.keySet().iterator();
            while (iterator.hasNext()) {
                Object importer = iterator.next();
                this.removeListener(importer, stateListener);
            }
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf((Class)ConfigurableListableBeanFactory.class, (Object)beanFactory);
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void destroy() {
        this.exportersSeen.clear();
        this.exporterListener.clear();
        this.exporterToImporterDeps.clear();
        this.exporterToName.clear();
        this.importerToName.clear();
    }

    private void startExporter(Object exporter) {
        ExporterControllerUtils.getControllerFor(exporter).registerService();
    }

    private void stopExporter(Object exporter) {
        ExporterControllerUtils.getControllerFor(exporter).unregisterService();
    }

    private void addListener(Object importer, ImporterStateListener stateListener) {
        ImporterInternalActions controller = ImporterControllerUtils.getControllerFor(importer);
        controller.addStateListener(stateListener);
    }

    private void removeListener(Object importer, ImporterStateListener stateListener) {
        ImporterInternalActions controller = ImporterControllerUtils.getControllerFor(importer);
        controller.removeStateListener(stateListener);
    }

    private boolean isSatisfied(Object importer) {
        return ImporterControllerUtils.getControllerFor(importer).isSatisfied();
    }

    private class ImporterDependencyListener
    implements ImporterStateListener {
        private final Object exporter;

        private ImporterDependencyListener(Object exporter) {
            this.exporter = exporter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void importerSatisfied(Object importer, OsgiServiceDependency dependency) {
            Object object = this.exporter;
            synchronized (object) {
                Map importers = (Map)DefaultMandatoryDependencyManager.this.exporterToImporterDeps.get(this.exporter);
                importers.put(importer, Boolean.TRUE);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Importer [" + DefaultMandatoryDependencyManager.this.importerToName.get(importer) + "] is satisfied; checking the rest of the dependencies for exporter " + DefaultMandatoryDependencyManager.this.exporterToName.get(this.exporter)));
                }
                DefaultMandatoryDependencyManager.this.checkIfExporterShouldStart(this.exporter, importers);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void importerUnsatisfied(Object importer, OsgiServiceDependency dependency) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exporter [" + DefaultMandatoryDependencyManager.this.exporterToName.get(this.exporter) + "] stopped; transitive OSGi dependency [" + dependency.getBeanName() + "] is unsatifised"));
            }
            DefaultMandatoryDependencyManager.this.stopExporter(this.exporter);
            Object object = this.exporter;
            synchronized (object) {
                Map importers = (Map)DefaultMandatoryDependencyManager.this.exporterToImporterDeps.get(this.exporter);
                importers.put(importer, Boolean.FALSE);
            }
        }
    }
}

