/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.List;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.IdUtil;

@JRubyClass(name={"Struct"})
public class RubyStruct
extends RubyObject {
    private IRubyObject[] values;
    private static ObjectAllocator STRUCT_INSTANCE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyStruct instance = new RubyStruct(runtime, klass);
            instance.setMetaClass(klass);
            return instance;
        }
    };

    public RubyStruct(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
        int size = RubyNumeric.fix2int(RubyStruct.getInternalVariable(rubyClass, "__size__"));
        this.values = new IRubyObject[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = this.getRuntime().getNil();
        }
    }

    public static RubyClass createStructClass(Ruby runtime) {
        RubyClass structClass = runtime.defineClass("Struct", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setStructClass(structClass);
        structClass.index = 15;
        structClass.includeModule(runtime.getEnumerable());
        structClass.defineAnnotatedMethods(RubyStruct.class);
        return structClass;
    }

    public int getNativeTypeIndex() {
        return 15;
    }

    private static IRubyObject getInternalVariable(RubyClass type, String internedName) {
        RubyClass structClass = type.getRuntime().getStructClass();
        while (type != null && type != structClass) {
            IRubyObject variable = type.fastGetInternalVariable(internedName);
            if (variable != null) {
                return variable;
            }
            type = type.getSuperClass();
        }
        return type.getRuntime().getNil();
    }

    private RubyClass classOf() {
        return this.getMetaClass() instanceof MetaClass ? this.getMetaClass().getSuperClass() : this.getMetaClass();
    }

    private void modify() {
        this.testFrozen("Struct is frozen");
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify struct");
        }
    }

    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        Ruby runtime = this.getRuntime();
        int h = this.getMetaClass().getRealClass().hashCode();
        for (int i = 0; i < this.values.length; ++i) {
            h = h << 1 | (h < 0 ? 1 : 0);
            h = (int)((long)h ^ RubyNumeric.num2long(this.values[i].callMethod(context, MethodIndex.HASH, "hash")));
        }
        return runtime.newFixnum(h);
    }

    private IRubyObject setByName(String name, IRubyObject value) {
        RubyArray member = (RubyArray)RubyStruct.getInternalVariable(this.classOf(), "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        this.modify();
        int k = member.getLength();
        for (int i = 0; i < k; ++i) {
            if (!member.eltInternal(i).asJavaString().equals(name)) continue;
            this.values[i] = value;
            return this.values[i];
        }
        throw this.notStructMemberError(name);
    }

    private IRubyObject getByName(String name) {
        RubyArray member = (RubyArray)RubyStruct.getInternalVariable(this.classOf(), "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        int k = member.getLength();
        for (int i = 0; i < k; ++i) {
            if (!member.eltInternal(i).asJavaString().equals(name)) continue;
            return this.values[i];
        }
        throw this.notStructMemberError(name);
    }

    @JRubyMethod(name={"new"}, required=1, rest=true, frame=true, meta=true)
    public static RubyClass newInstance(IRubyObject recv, IRubyObject[] args, Block block) {
        int i;
        RubyClass newStruct;
        int i2;
        String name = null;
        boolean nilName = false;
        Ruby runtime = recv.getRuntime();
        if (args.length > 0) {
            IRubyObject firstArgAsString = args[0].checkStringType();
            if (!firstArgAsString.isNil()) {
                name = ((RubyString)firstArgAsString).getByteList().toString();
            } else if (args[0].isNil()) {
                nilName = true;
            }
        }
        RubyArray member = runtime.newArray();
        int n = i2 = name == null && !nilName ? 0 : 1;
        while (i2 < args.length) {
            member.append(runtime.newSymbol(args[i2].asJavaString()));
            ++i2;
        }
        RubyClass superClass = (RubyClass)recv;
        if (name == null || nilName) {
            newStruct = RubyClass.newClass(runtime, superClass);
            newStruct.setAllocator(STRUCT_INSTANCE_ALLOCATOR);
            newStruct.makeMetaClass(superClass.getMetaClass());
            newStruct.inherit(superClass);
        } else {
            if (!IdUtil.isConstant(name)) {
                throw runtime.newNameError("identifier " + name + " needs to be constant", name);
            }
            IRubyObject type = superClass.getConstantAt(name);
            if (type != null) {
                Frame frame = runtime.getCurrentContext().getCurrentFrame();
                runtime.getWarnings().warn(IRubyWarnings.ID.STRUCT_CONSTANT_REDEFINED, frame.getFile(), frame.getLine(), "redefining constant Struct::" + name, name);
                superClass.remove_const(runtime.newString(name));
            }
            newStruct = superClass.defineClassUnder(name, superClass, STRUCT_INSTANCE_ALLOCATOR);
        }
        newStruct.index = 15;
        newStruct.fastSetInternalVariable("__size__", member.length());
        newStruct.fastSetInternalVariable("__member__", member);
        newStruct.getSingletonClass().defineAnnotatedMethods(StructMethods.class);
        int n2 = i = name == null && !nilName ? 0 : 1;
        while (i < args.length) {
            String memberName = args[i].asJavaString();
            final int index = name == null && !nilName ? i : i - 1;
            newStruct.addMethod(memberName, new DynamicMethod(newStruct, Visibility.PUBLIC, CallConfiguration.NO_FRAME_NO_SCOPE){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
                    Arity.checkArgumentCount(self.getRuntime(), args, 0, 0);
                    return ((RubyStruct)self).get(index);
                }

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name) {
                    return ((RubyStruct)self).get(index);
                }

                public DynamicMethod dup() {
                    return this;
                }
            });
            newStruct.addMethod(memberName + "=", new DynamicMethod(newStruct, Visibility.PUBLIC, CallConfiguration.NO_FRAME_NO_SCOPE){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
                    Arity.checkArgumentCount(self.getRuntime(), args, 1, 1);
                    return ((RubyStruct)self).set(args[0], index);
                }

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg) {
                    return ((RubyStruct)self).set(arg, index);
                }

                public DynamicMethod dup() {
                    return this;
                }
            });
            ++i;
        }
        if (block.isGiven()) {
            block.getBinding().setVisibility(Visibility.PUBLIC);
            block.yield(runtime.getCurrentContext(), null, newStruct, newStruct, false);
        }
        return newStruct;
    }

    public static RubyStruct newStruct(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyStruct struct = new RubyStruct(recv.getRuntime(), (RubyClass)recv);
        struct.callInit(args, block);
        return struct;
    }

    @JRubyMethod(rest=true, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args, Block unusedBlock) {
        this.modify();
        int size = RubyNumeric.fix2int(RubyStruct.getInternalVariable(this.getMetaClass(), "__size__"));
        if (args.length > size) {
            throw this.getRuntime().newArgumentError("struct size differs (" + args.length + " for " + size + ")");
        }
        for (int i = 0; i < args.length; ++i) {
            this.values[i] = args[i];
        }
        return this.getRuntime().getNil();
    }

    public static RubyArray members(IRubyObject recv, Block block) {
        RubyArray member = (RubyArray)RubyStruct.getInternalVariable((RubyClass)recv, "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        RubyArray result = recv.getRuntime().newArray(member.getLength());
        int k = member.getLength();
        for (int i = 0; i < k; ++i) {
            result.append(recv.getRuntime().newString(member.eltInternal(i).asJavaString()));
        }
        return result;
    }

    @JRubyMethod
    public RubyArray members() {
        return RubyStruct.members(this.classOf(), Block.NULL_BLOCK);
    }

    @JRubyMethod
    public RubyArray select(ThreadContext context, Block block) {
        RubyArray array = RubyArray.newArray(context.getRuntime());
        for (int i = 0; i < this.values.length; ++i) {
            if (!block.yield(context, this.values[i]).isTrue()) continue;
            array.append(this.values[i]);
        }
        return array;
    }

    public IRubyObject set(IRubyObject value, int index) {
        RubyArray member = (RubyArray)RubyStruct.getInternalVariable(this.classOf(), "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        this.modify();
        this.values[index] = value;
        return this.values[index];
    }

    private RaiseException notStructMemberError(String name) {
        return this.getRuntime().newNameError(name + " is not struct member", name);
    }

    public IRubyObject get(int index) {
        RubyArray member = (RubyArray)RubyStruct.getInternalVariable(this.classOf(), "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        return this.values[index];
    }

    public void copySpecialInstanceVariables(IRubyObject clone) {
        RubyStruct struct = (RubyStruct)clone;
        struct.values = new IRubyObject[this.values.length];
        System.arraycopy(this.values, 0, struct.values, 0, this.values.length);
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyStruct)) {
            return this.getRuntime().getFalse();
        }
        if (this.getMetaClass().getRealClass() != other.getMetaClass().getRealClass()) {
            return this.getRuntime().getFalse();
        }
        Ruby runtime = this.getRuntime();
        RubyStruct otherStruct = (RubyStruct)other;
        for (int i = 0; i < this.values.length; ++i) {
            if (RubyStruct.equalInternal(context, this.values[i], otherStruct.values[i])) continue;
            return runtime.getFalse();
        }
        return runtime.getTrue();
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyStruct)) {
            return this.getRuntime().getFalse();
        }
        if (this.getMetaClass() != other.getMetaClass()) {
            return this.getRuntime().getFalse();
        }
        Ruby runtime = this.getRuntime();
        RubyStruct otherStruct = (RubyStruct)other;
        for (int i = 0; i < this.values.length; ++i) {
            if (RubyStruct.eqlInternal(context, this.values[i], otherStruct.values[i])) continue;
            return runtime.getFalse();
        }
        return runtime.getTrue();
    }

    private IRubyObject inspectStruct(ThreadContext context) {
        RubyArray member = (RubyArray)RubyStruct.getInternalVariable(this.classOf(), "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        ByteList buffer = new ByteList("#<struct ".getBytes());
        buffer.append(this.getMetaClass().getRealClass().getRealClass().getName().getBytes());
        buffer.append(32);
        int k = member.getLength();
        for (int i = 0; i < k; ++i) {
            if (i > 0) {
                buffer.append(44).append(32);
            }
            buffer.append(RubyString.objAsString(context, member.eltInternal(i)).getByteList());
            buffer.append(61);
            buffer.append(RubyStruct.inspect(context, this.values[i]).getByteList());
        }
        buffer.append(62);
        return this.getRuntime().newString(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"inspect", "to_s"})
    public IRubyObject inspect(ThreadContext context) {
        if (this.getRuntime().isInspecting(this)) {
            return this.getRuntime().newString("#<struct " + this.getMetaClass().getRealClass().getName() + ":...>");
        }
        try {
            this.getRuntime().registerInspecting(this);
            IRubyObject iRubyObject = this.inspectStruct(context);
            return iRubyObject;
        }
        finally {
            this.getRuntime().unregisterInspecting(this);
        }
    }

    @JRubyMethod(name={"to_a", "values"})
    public RubyArray to_a() {
        return this.getRuntime().newArray(this.values);
    }

    @JRubyMethod(name={"size", "length"})
    public RubyFixnum size() {
        return this.getRuntime().newFixnum(this.values.length);
    }

    @JRubyMethod(name={"each"}, backtrace=true)
    public IRubyObject each(ThreadContext context, Block block) {
        for (int i = 0; i < this.values.length; ++i) {
            block.yield(context, this.values[i]);
        }
        return this;
    }

    @JRubyMethod(frame=true)
    public IRubyObject each_pair(ThreadContext context, Block block) {
        RubyArray member = (RubyArray)RubyStruct.getInternalVariable(this.classOf(), "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        for (int i = 0; i < this.values.length; ++i) {
            block.yield(context, this.getRuntime().newArrayNoCopy(new IRubyObject[]{member.eltInternal(i), this.values[i]}));
        }
        return this;
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject aref(IRubyObject key) {
        if (key instanceof RubyString || key instanceof RubySymbol) {
            return this.getByName(key.asJavaString());
        }
        int idx = RubyNumeric.fix2int(key);
        int n = idx = idx < 0 ? this.values.length + idx : idx;
        if (idx < 0) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        if (idx >= this.values.length) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        return this.values[idx];
    }

    @JRubyMethod(name={"[]="}, required=2)
    public IRubyObject aset(IRubyObject key, IRubyObject value) {
        if (key instanceof RubyString || key instanceof RubySymbol) {
            return this.setByName(key.asJavaString(), value);
        }
        int idx = RubyNumeric.fix2int(key);
        int n = idx = idx < 0 ? this.values.length + idx : idx;
        if (idx < 0) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        if (idx >= this.values.length) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        this.modify();
        this.values[idx] = value;
        return this.values[idx];
    }

    @JRubyMethod(rest=true)
    public IRubyObject values_at(IRubyObject[] args) {
        long olen = this.values.length;
        RubyArray result = this.getRuntime().newArray(args.length);
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof RubyFixnum) {
                result.append(this.aref(args[i]));
                continue;
            }
            if (args[i] instanceof RubyRange) {
                int len;
                long[] beglen = ((RubyRange)args[i]).begLen(olen, 0);
                if (beglen == null) continue;
                int beg = (int)beglen[0];
                int end = len = (int)beglen[1];
                for (int j = 0; j < end; ++j) {
                    result.append(this.aref(this.getRuntime().newFixnum(j + beg)));
                }
                continue;
            }
            result.append(this.aref(this.getRuntime().newFixnum(RubyNumeric.num2long(args[i]))));
        }
        return result;
    }

    public static void marshalTo(RubyStruct struct, MarshalStream output) throws IOException {
        output.registerLinkTarget(struct);
        output.dumpDefaultObjectHeader('S', struct.getMetaClass());
        List members = ((RubyArray)RubyStruct.getInternalVariable(struct.classOf(), "__member__")).getList();
        output.writeInt(members.size());
        for (int i = 0; i < members.size(); ++i) {
            RubySymbol name = (RubySymbol)members.get(i);
            output.dumpObject(name);
            output.dumpObject(struct.values[i]);
        }
    }

    public static RubyStruct unmarshalFrom(UnmarshalStream input) throws IOException {
        RubySymbol className;
        Ruby runtime = input.getRuntime();
        RubyClass rbClass = RubyStruct.pathToClass(runtime, (className = (RubySymbol)input.unmarshalObject()).asJavaString());
        if (rbClass == null) {
            throw runtime.newNameError("uninitialized constant " + className, className.asJavaString());
        }
        RubyArray mem = RubyStruct.members(rbClass, Block.NULL_BLOCK);
        int len = input.unmarshalInt();
        IRubyObject[] values = new IRubyObject[len];
        for (int i = 0; i < len; ++i) {
            values[i] = runtime.getNil();
        }
        RubyStruct result = RubyStruct.newStruct(rbClass, values, Block.NULL_BLOCK);
        input.registerLinkTarget(result);
        for (int i = 0; i < len; ++i) {
            IRubyObject slot = input.unmarshalObject();
            if (!mem.eltInternal(i).toString().equals(slot.toString())) {
                throw runtime.newTypeError("struct " + rbClass.getName() + " not compatible (:" + slot + " for :" + mem.eltInternal(i) + ")");
            }
            result.aset(runtime.newFixnum(i), input.unmarshalObject());
        }
        return result;
    }

    private static RubyClass pathToClass(Ruby runtime, String path) {
        return (RubyClass)runtime.getClassFromPath(path);
    }

    @JRubyMethod(required=1)
    public IRubyObject initialize_copy(IRubyObject arg) {
        if (this == arg) {
            return this;
        }
        RubyStruct original = (RubyStruct)arg;
        this.values = new IRubyObject[original.values.length];
        System.arraycopy(original.values, 0, this.values, 0, original.values.length);
        return this;
    }

    public static class StructMethods {
        @JRubyMethod(name={"new", "[]"}, rest=true, frame=true)
        public static IRubyObject newStruct(IRubyObject recv, IRubyObject[] args, Block block) {
            return RubyStruct.newStruct(recv, args, block);
        }

        @JRubyMethod
        public static IRubyObject members(IRubyObject recv, Block block) {
            return RubyStruct.members(recv, block);
        }
    }
}

