/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"UnboundMethod"}, parent="Method")
public class RubyUnboundMethod
extends RubyMethod {
    protected RubyUnboundMethod(Ruby runtime) {
        super(runtime, runtime.getUnboundMethod());
    }

    public static RubyUnboundMethod newUnboundMethod(RubyModule implementationModule, String methodName, RubyModule originModule, String originName, DynamicMethod method) {
        RubyUnboundMethod newMethod = new RubyUnboundMethod(implementationModule.getRuntime());
        newMethod.implementationModule = implementationModule;
        newMethod.methodName = methodName;
        newMethod.originModule = originModule;
        newMethod.originName = originName;
        newMethod.method = method;
        return newMethod;
    }

    public static RubyClass defineUnboundMethodClass(Ruby runtime) {
        RubyClass newClass = runtime.defineClass("UnboundMethod", runtime.getMethod(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setUnboundMethod(newClass);
        newClass.defineAnnotatedMethods(RubyUnboundMethod.class);
        return newClass;
    }

    @JRubyMethod(name={"call", "[]"}, rest=true, frame=true)
    public IRubyObject call(IRubyObject[] args, Block block) {
        throw this.getRuntime().newTypeError("you cannot call unbound method; bind first");
    }

    @JRubyMethod(name={"unbind"}, frame=true)
    public RubyUnboundMethod unbind(Block block) {
        return this;
    }

    @JRubyMethod(name={"bind"}, required=1, frame=true)
    public RubyMethod bind(IRubyObject aReceiver, Block block) {
        RubyClass receiverClass = aReceiver.getMetaClass();
        if (!this.originModule.isInstance(aReceiver)) {
            if (this.originModule instanceof MetaClass) {
                throw this.getRuntime().newTypeError("singleton method called for a different object");
            }
            if (receiverClass instanceof MetaClass && receiverClass.getMethods().containsKey(this.originName)) {
                throw this.getRuntime().newTypeError("method `" + this.originName + "' overridden");
            }
            if (!(!this.originModule.isModule() ? aReceiver.getType() == this.originModule : this.originModule.isInstance(aReceiver))) {
                throw this.getRuntime().newTypeError("bind argument must be an instance of " + this.originModule.getName());
            }
        }
        return RubyMethod.newMethod(this.implementationModule, this.methodName, receiverClass, this.originName, this.method, aReceiver);
    }

    @JRubyMethod(name={"clone"})
    public RubyMethod rbClone() {
        return RubyUnboundMethod.newUnboundMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method);
    }

    @JRubyMethod(name={"to_proc"}, frame=true)
    public IRubyObject to_proc(Block unusedBlock) {
        return super.to_proc(unusedBlock);
    }
}

