/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleAsgnNode
extends AssignableNode {
    private final ListNode headNode;
    private final Node argsNode;

    public MultipleAsgnNode(ISourcePosition position, ListNode headNode, Node argsNode) {
        super(position, NodeType.MULTIPLEASGNNODE);
        this.headNode = headNode;
        this.argsNode = argsNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitMultipleAsgnNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public ListNode getHeadNode() {
        return this.headNode;
    }

    @Override
    public Arity getArity() {
        if (this.argsNode != null) {
            return Arity.required(this.headNode == null ? 0 : this.headNode.size());
        }
        return Arity.fixed(this.headNode.size());
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.headNode, this.argsNode, this.getValueNode());
    }
}

