/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.runtime.builtin.IRubyObject;

public final class ValueConverter {
    private Ruby runtime;

    public ValueConverter(Ruby runtime) {
        this.runtime = runtime;
    }

    public RubyArray singleToArray(IRubyObject value) {
        if (value == null || value.isNil()) {
            return this.runtime.newEmptyArray();
        }
        if (value instanceof RubyArray) {
            if (((RubyArray)value).getLength() == 1) {
                return (RubyArray)value;
            }
            return this.runtime.newArray(value);
        }
        return this.toArray(value);
    }

    public IRubyObject arrayToSingle(IRubyObject value, boolean useUndefined) {
        if (!(value instanceof RubyArray)) {
            value = this.toArray(value);
        }
        switch (((RubyArray)value).getLength()) {
            case 0: {
                return useUndefined ? null : this.runtime.getNil();
            }
            case 1: {
                return ((RubyArray)value).eltInternal(0);
            }
        }
        return value;
    }

    public RubyArray singleToMultiple(IRubyObject value) {
        if (value == null || value.isNil()) {
            return this.runtime.newEmptyArray();
        }
        if (value instanceof RubyArray) {
            return (RubyArray)value;
        }
        return this.toArray(value);
    }

    public IRubyObject multipleToSingle(IRubyObject value) {
        if (!(value instanceof RubyArray)) {
            value = this.toArray(value);
        }
        switch (((RubyArray)value).getLength()) {
            case 0: {
                return this.runtime.getNil();
            }
            case 1: {
                if (((RubyArray)value).eltInternal(0) instanceof RubyArray) break;
                return ((RubyArray)value).eltInternal(0);
            }
        }
        return value;
    }

    private RubyArray toArray(IRubyObject value) {
        if (value.isNil()) {
            return this.runtime.newEmptyArray();
        }
        if (value instanceof RubyArray) {
            return (RubyArray)value;
        }
        if (value.respondsTo("to_ary")) {
            return value.convertToArray();
        }
        return this.runtime.newArray(value);
    }
}

