/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.io.File;
import java.io.FileOutputStream;
import jruby.objectweb.asm.ClassWriter;
import org.jruby.internal.runtime.methods.InvocationMethodFactory;

public class DumpingInvocationMethodFactory
extends InvocationMethodFactory {
    private String dumpPath;

    public DumpingInvocationMethodFactory(String path, ClassLoader classLoader) {
        super(classLoader);
        this.dumpPath = path;
    }

    protected Class endClass(ClassWriter cw, String name) {
        cw.visitEnd();
        byte[] code = cw.toByteArray();
        String cname = name.replace('.', '/');
        File f = new File(this.dumpPath, cname + ".class");
        f.getParentFile().mkdirs();
        try {
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(code);
            fos.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.classLoader.defineClass(name, code);
    }
}

