/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.runtime.Block;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public final class Frame
implements JumpTarget {
    private RubyModule klazz;
    private IRubyObject self;
    private String name;
    private Block block;
    private boolean isBindingFrame = false;
    private Visibility visibility = Visibility.PUBLIC;
    private JumpTarget jumpTarget;
    private IRubyObject[] backrefAndLastline;
    private String fileName;
    private int line;

    public JumpTarget getJumpTarget() {
        return this.jumpTarget;
    }

    public void setJumpTarget(JumpTarget jumpTarget) {
        this.jumpTarget = jumpTarget;
    }

    public void updateFrame(String fileName, int line) {
        this.updateFrame(null, null, null, Block.NULL_BLOCK, fileName, line, null);
    }

    public void updateFrame(Frame frame) {
        assert (frame.block != null) : "Block uses null object pattern.  It should NEVER be null";
        this.self = frame.self;
        this.name = frame.name;
        this.klazz = frame.klazz;
        this.fileName = frame.fileName;
        this.line = frame.line;
        this.block = frame.block;
        this.jumpTarget = frame.jumpTarget;
        this.visibility = frame.visibility;
        this.isBindingFrame = frame.isBindingFrame;
        this.backrefAndLastline = frame.backrefAndLastline;
    }

    public void updateFrame(RubyModule klazz, IRubyObject self, String name, Block block, String fileName, int line, JumpTarget jumpTarget) {
        assert (block != null) : "Block uses null object pattern.  It should NEVER be null";
        this.self = self;
        this.name = name;
        this.klazz = klazz;
        this.fileName = fileName;
        this.line = line;
        this.block = block;
        this.jumpTarget = jumpTarget;
        this.visibility = Visibility.PUBLIC;
        this.isBindingFrame = false;
        this.backrefAndLastline = new IRubyObject[2];
    }

    public void updateFrame(String name, String fileName, int line) {
        this.name = name;
        this.fileName = fileName;
        this.line = line;
    }

    public Frame duplicate() {
        Frame newFrame = new Frame();
        newFrame.updateFrame(this);
        return newFrame;
    }

    public IRubyObject getBackRef() {
        return this.backrefAndLastline[0] == null ? this.self.getRuntime().getNil() : this.backrefAndLastline[0];
    }

    public IRubyObject setBackRef(IRubyObject backref) {
        this.backrefAndLastline[0] = backref;
        return this.backrefAndLastline[0];
    }

    public IRubyObject getLastLine() {
        return this.backrefAndLastline[1] == null ? this.self.getRuntime().getNil() : this.backrefAndLastline[1];
    }

    public IRubyObject setLastLine(IRubyObject lastline) {
        this.backrefAndLastline[1] = lastline;
        return this.backrefAndLastline[1];
    }

    public String getFile() {
        return this.fileName;
    }

    public int getLine() {
        return this.line;
    }

    public void setFile(String fileName) {
        this.fileName = fileName;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public RubyModule getKlazz() {
        return this.klazz;
    }

    public void setKlazz(RubyModule klazz) {
        this.klazz = klazz;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    IRubyObject getSelf() {
        return this.self;
    }

    public void setSelf(IRubyObject self) {
        this.self = self;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public boolean isBindingFrame() {
        return this.isBindingFrame;
    }

    public void setIsBindingFrame(boolean isBindingFrame) {
        this.isBindingFrame = isBindingFrame;
    }

    public Block getBlock() {
        return this.block;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(50);
        sb.append(this.fileName).append(':').append(this.line + 1).append(':').append(this.klazz);
        if (this.name != null) {
            sb.append(" in ").append(this.name);
        }
        return sb.toString();
    }
}

