/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Join {
    public static final Executor TRIVIAL_EXECUTOR = new Executor(){

        public void execute(Runnable command) {
            new Thread(command).start();
        }
    };
    private final Executor executor;
    private final LinkedList[] writes;
    private final long asyncMask;
    private long mask = 0L;
    private final Reaction[][] reactionsPerChannel;

    private Join(long asyncMask, Reaction[][] reactionsPerChannel, Executor executor) {
        LinkedList[] writes = new LinkedList[reactionsPerChannel.length];
        for (int i = 0; i < writes.length; ++i) {
            if (reactionsPerChannel[i] == null) continue;
            writes[i] = new LinkedList();
        }
        this.asyncMask = asyncMask;
        this.reactionsPerChannel = reactionsPerChannel;
        this.writes = writes;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRaw(int index, Object message) {
        Reaction selectedReaction = null;
        Object[] args = null;
        Join join = this;
        synchronized (join) {
            Reaction[] reactions;
            LinkedList writing = this.writes[index];
            if (writing == null) {
                throw new IndexOutOfBoundsException();
            }
            writing.addLast(message);
            this.mask |= 1L << index;
            for (Reaction reaction : reactions = this.reactionsPerChannel[index]) {
                if ((reaction.mask & this.mask) != reaction.mask) continue;
                int[] indices = reaction.indices;
                args = new Object[indices.length];
                for (int i = 0; i < indices.length; ++i) {
                    int readIndex = indices[i];
                    LinkedList reading = this.writes[readIndex];
                    args[i] = reading.removeFirst();
                    if (!reading.isEmpty()) continue;
                    this.mask &= 1L << readIndex ^ 0xFFFFFFFFFFFFFFFFL;
                }
                selectedReaction = reaction;
                break;
            }
        }
        if (selectedReaction != null) {
            selectedReaction.dispatch(this, args);
        }
    }

    public boolean isAsync(int channel) {
        return (1L << channel & this.asyncMask) != 0L;
    }

    public void send(int channel, Object message) {
        if (this.isAsync(channel)) {
            this.sendRaw(channel, message);
        } else {
            this.sendRaw(channel, new AsyncCall(message));
        }
    }

    public void send(Enum<?> channel, Object message) {
        this.send(channel.ordinal(), message);
    }

    public Object call(int channel, Object message) {
        if (this.isAsync(channel)) {
            this.sendRaw(channel, message);
            return null;
        }
        SyncCall request = new SyncCall(message);
        this.sendRaw(channel, request);
        return request.call();
    }

    public Object call(Enum<?> channel, Object message) {
        return this.call(channel.ordinal(), message);
    }

    private static class SyncCall
    extends Call {
        private Join join = null;
        private SyncReaction reaction = null;
        private Object[] args = null;

        public SyncCall(Object message) {
            super(message);
        }

        public synchronized void activate(Join join, SyncReaction reaction, Object[] args) {
            this.join = join;
            this.reaction = reaction;
            this.args = args;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Object call() {
            boolean interrupted = false;
            try {
                while (this.reaction == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.reaction.react(this.join, this.args);
        }
    }

    private static class AsyncCall
    extends Call {
        public AsyncCall(Object message) {
            super(message);
        }

        public void activate(final Join join, final SyncReaction reaction, final Object[] args) {
            join.executor.execute(new Runnable(){

                public void run() {
                    reaction.react(join, args);
                }
            });
        }
    }

    private static abstract class Call {
        private final Object message;

        public Call(Object message) {
            this.message = message;
        }

        public Object getMessage() {
            return this.message;
        }

        public abstract void activate(Join var1, SyncReaction var2, Object[] var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class SyncReaction
    extends Reaction {
        public SyncReaction(int[] indices) {
            super((int[])indices.clone(), false);
        }

        public SyncReaction(Enum<?> head, Enum<?> ... channels) {
            super(head, channels, false);
        }

        @Override
        void dispatch(Join join, Object[] args) {
            Call call = (Call)args[0];
            args[0] = call.getMessage();
            call.activate(join, this, args);
        }

        public abstract Object react(Join var1, Object[] var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AsyncReaction
    extends Reaction {
        public AsyncReaction(int[] indices) {
            super((int[])indices.clone(), true);
        }

        public AsyncReaction(Enum<?> head, Enum<?> ... channels) {
            super(head, channels, true);
        }

        @Override
        void dispatch(final Join join, final Object[] args) {
            final AsyncReaction reaction = this;
            join.executor.execute(new Runnable(){

                public void run() {
                    reaction.react(join, args);
                }
            });
        }

        public abstract void react(Join var1, Object[] var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class FastReaction
    extends Reaction {
        public FastReaction(int[] indices) {
            super((int[])indices.clone(), true);
        }

        public FastReaction(Enum<?> head, Enum<?> ... channels) {
            super(head, channels, true);
        }

        @Override
        void dispatch(Join join, Object[] args) {
            try {
                this.react(join, args);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public abstract void react(Join var1, Object[] var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Reaction {
        private final int[] indices;
        private final long mask;
        private final long asyncMask;

        private static int[] toIndices(Enum<?> head, Enum<?>[] channels) {
            int[] indices = new int[channels.length + 1];
            indices[0] = head.ordinal();
            for (int i = 0; i < channels.length; ++i) {
                indices[i + 1] = channels[i].ordinal();
            }
            return indices;
        }

        Reaction(Enum<?> head, Enum<?>[] channels, boolean isAsync) {
            this(Reaction.toIndices(head, channels), isAsync);
        }

        Reaction(int[] indices, boolean isAsync) {
            long mask = 0L;
            for (int i = 0; i < indices.length; ++i) {
                int index = indices[i];
                if (index < 0 || index > 63) {
                    throw new IndexOutOfBoundsException();
                }
                if ((mask & 1L << index) != 0L) {
                    throw new IllegalArgumentException("Duplicate channels in reaction");
                }
                mask |= 1L << index;
            }
            this.indices = indices;
            this.mask = mask;
            this.asyncMask = isAsync ? mask : mask & (1L << indices[0] ^ 0xFFFFFFFFFFFFFFFFL);
        }

        abstract void dispatch(Join var1, Object[] var2);
    }

    public static class Spec {
        private ArrayList<ArrayList<Reaction>> reactionsPerChannel = new ArrayList();
        private long asyncMask = 0L;
        private long mask = 0L;
        private volatile Reaction[][] cachedReactionsPerChannel = null;
        private static final Reaction[] EMPTY_REACTIONS = new Reaction[0];

        public void addReaction(Reaction reaction) {
            if ((this.mask & (this.asyncMask ^ 0xFFFFFFFFFFFFFFFFL) & reaction.asyncMask) != 0L) {
                throw new IllegalArgumentException("Cannot use a synchronous channel in a non-head position");
            }
            if ((reaction.mask & (reaction.asyncMask ^ 0xFFFFFFFFFFFFFFFFL) & this.asyncMask) != 0L) {
                throw new IllegalArgumentException("Cannot use an asynchronous channel in the head position of a synchronous reaction");
            }
            this.cachedReactionsPerChannel = null;
            int[] indices = reaction.indices;
            for (int i = 0; i < indices.length; ++i) {
                ArrayList<Reaction> reactions;
                int index = indices[i];
                if (this.reactionsPerChannel.size() <= index) {
                    this.reactionsPerChannel.ensureCapacity(index + 1);
                    while (this.reactionsPerChannel.size() <= index) {
                        this.reactionsPerChannel.add(null);
                    }
                }
                if ((reactions = this.reactionsPerChannel.get(index)) == null) {
                    reactions = new ArrayList();
                    this.reactionsPerChannel.set(index, reactions);
                }
                reactions.add(reaction);
            }
            this.asyncMask |= reaction.asyncMask;
            this.mask |= reaction.mask;
        }

        public Join createJoin() {
            return this.createJoin(TRIVIAL_EXECUTOR);
        }

        public Join createJoin(Executor executor) {
            if (this.cachedReactionsPerChannel == null) {
                int length = this.reactionsPerChannel.size();
                Reaction[][] localReactionsPerChannel = new Reaction[length][];
                for (int i = 0; i < length; ++i) {
                    ArrayList<Reaction> reactions = this.reactionsPerChannel.get(i);
                    if (reactions == null) continue;
                    localReactionsPerChannel[i] = reactions.toArray(EMPTY_REACTIONS);
                }
                this.cachedReactionsPerChannel = localReactionsPerChannel;
            }
            return new Join(this.asyncMask, this.cachedReactionsPerChannel, executor);
        }
    }
}

