/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.main;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Properties;
import org.apache.servicemix.kernel.main.Lock;

public class SimpleFileLock
implements Lock {
    private static final String PROPERTY_LOCK_DIR = "servicemix.lock.dir";
    private static final String PROP_SERVICEMIX_BASE = "servicemix.base";
    private RandomAccessFile lockFile;
    private FileLock lock;

    public SimpleFileLock(Properties props) {
        try {
            String lock = props.getProperty(PROPERTY_LOCK_DIR);
            if (lock != null) {
                File servicemixLock = SimpleFileLock.getServiceMixLock(new File(lock), props);
                props.setProperty(PROPERTY_LOCK_DIR, servicemixLock.getPath());
            } else {
                props.setProperty(PROPERTY_LOCK_DIR, System.getProperty(PROP_SERVICEMIX_BASE));
            }
            File base = new File(props.getProperty(PROPERTY_LOCK_DIR));
            this.lockFile = new RandomAccessFile(new File(base, "lock"), "rw");
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create file lock", e);
        }
    }

    public boolean lock() throws Exception {
        if (this.lock == null) {
            this.lock = this.lockFile.getChannel().tryLock();
        }
        return this.lock != null;
    }

    public void release() throws Exception {
        if (this.lock != null && this.lock.isValid()) {
            this.lock.release();
            this.lock.channel().close();
        }
        this.lock = null;
    }

    private static File getServiceMixLock(File lock, Properties props) {
        File rc = null;
        String path = lock.getPath();
        if (path != null) {
            rc = SimpleFileLock.validateDirectoryExists(path, "Invalid servicemix.lock.dir system property");
        }
        if (rc == null && (path = props.getProperty(PROP_SERVICEMIX_BASE)) != null) {
            rc = SimpleFileLock.validateDirectoryExists(path, "Invalid servicemix.base property");
        }
        if (rc == null) {
            rc = lock;
        }
        return rc;
    }

    private static File validateDirectoryExists(String path, String errPrefix) {
        File rc;
        try {
            rc = new File(path).getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(errPrefix + " '" + path + "' : " + e.getMessage());
        }
        if (!rc.exists()) {
            throw new IllegalArgumentException(errPrefix + " '" + path + "' : does not exist");
        }
        if (!rc.isDirectory()) {
            throw new IllegalArgumentException(errPrefix + " '" + path + "' : is not a directory");
        }
        return rc;
    }
}

