/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.annotation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.reflect.PerClauseKind;
import org.springframework.aop.Advisor;
import org.springframework.aop.aspectj.AspectJProxyUtils;
import org.springframework.aop.aspectj.annotation.AspectJAdvisorFactory;
import org.springframework.aop.aspectj.annotation.AspectMetadata;
import org.springframework.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import org.springframework.aop.aspectj.annotation.ReflectiveAspectJAdvisorFactory;
import org.springframework.aop.aspectj.annotation.SimpleMetadataAwareAspectInstanceFactory;
import org.springframework.aop.aspectj.annotation.SingletonMetadataAwareAspectInstanceFactory;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.ProxyCreatorSupport;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectJProxyFactory
extends ProxyCreatorSupport {
    private static final Map aspectCache = new HashMap();
    private final AspectJAdvisorFactory aspectFactory = new ReflectiveAspectJAdvisorFactory();

    public AspectJProxyFactory() {
    }

    public AspectJProxyFactory(Object target) {
        Assert.notNull((Object)target, (String)"Target object must not be null");
        this.setInterfaces(ClassUtils.getAllInterfaces((Object)target));
        this.setTarget(target);
    }

    public AspectJProxyFactory(Class[] interfaces) {
        this.setInterfaces(interfaces);
    }

    public void addAspect(Object aspectInstance) {
        String aspectName;
        Class<?> aspectClass = aspectInstance.getClass();
        AspectMetadata am = this.createAspectMetadata(aspectClass, aspectName = aspectClass.getName());
        if (am.getAjType().getPerClause().getKind() != PerClauseKind.SINGLETON) {
            throw new IllegalArgumentException("Aspect class [" + aspectClass.getName() + "] does not define a singleton aspect");
        }
        this.addAdvisorsFromAspectInstanceFactory(new SingletonMetadataAwareAspectInstanceFactory(aspectInstance, aspectName));
    }

    public void addAspect(Class aspectClass) {
        String aspectName = aspectClass.getName();
        AspectMetadata am = this.createAspectMetadata(aspectClass, aspectName);
        MetadataAwareAspectInstanceFactory instanceFactory = this.createAspectInstanceFactory(am, aspectClass, aspectName);
        this.addAdvisorsFromAspectInstanceFactory(instanceFactory);
    }

    private void addAdvisorsFromAspectInstanceFactory(MetadataAwareAspectInstanceFactory instanceFactory) {
        List advisors = this.aspectFactory.getAdvisors(instanceFactory);
        advisors = AopUtils.findAdvisorsThatCanApply(advisors, this.getTargetClass());
        this.addAllAdvisors(advisors.toArray(new Advisor[advisors.size()]));
        this.makeAdvisorChainAspectJCapableIfNecessary();
    }

    private AspectMetadata createAspectMetadata(Class aspectClass, String aspectName) {
        AspectMetadata am = new AspectMetadata(aspectClass, aspectName);
        if (!am.getAjType().isAspect()) {
            throw new IllegalArgumentException("Class [" + aspectClass.getName() + "] is not a valid aspect type");
        }
        return am;
    }

    private MetadataAwareAspectInstanceFactory createAspectInstanceFactory(AspectMetadata am, Class aspectClass, String aspectName) {
        MetadataAwareAspectInstanceFactory instanceFactory = null;
        if (am.getAjType().getPerClause().getKind() == PerClauseKind.SINGLETON) {
            Object instance = this.getSingletonAspectInstance(aspectClass);
            instanceFactory = new SingletonMetadataAwareAspectInstanceFactory(instance, aspectName);
        } else {
            instanceFactory = new SimpleMetadataAwareAspectInstanceFactory(aspectClass, aspectName);
        }
        return instanceFactory;
    }

    private void makeAdvisorChainAspectJCapableIfNecessary() {
        if (AspectJProxyUtils.makeAdvisorChainAspectJCapableIfNecessary(this.getAdvisorsInternal())) {
            this.updateAdvisorArray();
            this.adviceChanged();
        }
    }

    private Object getSingletonAspectInstance(Class aspectClass) {
        Map map = aspectCache;
        synchronized (map) {
            Object instance = aspectCache.get(aspectClass);
            if (instance != null) {
                return instance;
            }
            try {
                instance = aspectClass.newInstance();
                aspectCache.put(aspectClass, instance);
                return instance;
            }
            catch (InstantiationException ex) {
                throw new AopConfigException("Unable to instantiate aspect class [" + aspectClass.getName() + "]", ex);
            }
            catch (IllegalAccessException ex) {
                throw new AopConfigException("Cannot access aspect class [" + aspectClass.getName() + "]", ex);
            }
        }
    }

    public <T> T getProxy() {
        return (T)this.createAopProxy().getProxy();
    }

    public <T> T getProxy(ClassLoader classLoader) {
        return (T)this.createAopProxy().getProxy(classLoader);
    }
}

