/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.geronimo;

import java.net.URI;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.servicemix.geronimo.Container;

public class Component
implements GBeanLifecycle {
    private static final Log log = LogFactory.getLog(Component.class);
    private String name;
    private String description;
    private String type;
    private String className;
    private Container container;
    private URI rootDir;
    private URI installDir;
    private URI workDir;
    private javax.jbi.component.Component component;
    private ClassLoader classLoader;
    public static final GBeanInfo GBEAN_INFO;

    public Component(String name, String description, String type, String className, Container container, URL configurationBaseUrl, ClassLoader classLoader) throws Exception {
        this.name = name;
        this.description = description;
        this.type = type;
        this.className = className;
        this.container = container;
        this.rootDir = configurationBaseUrl.getProtocol().equalsIgnoreCase("file") ? new URI("file", configurationBaseUrl.getPath(), null) : URI.create(configurationBaseUrl.toString());
        this.installDir = this.rootDir.resolve("install/");
        this.workDir = this.rootDir.resolve("workspace/");
        this.classLoader = classLoader;
        log.info((Object)("Created JBI component: " + name));
    }

    public void doStart() throws Exception {
        log.info((Object)("doStart called for JBI component: " + this.name));
        try {
            this.component = (javax.jbi.component.Component)this.classLoader.loadClass(this.className).newInstance();
            this.container.register(this);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)this.classLoader);
        }
    }

    public void doStop() throws Exception {
        log.info((Object)("doStop called for JBI component: " + this.name));
        this.container.unregister(this);
        this.component = null;
    }

    public void doFail() {
        log.info((Object)("doFail called for JBI component: " + this.name));
        this.component = null;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public URI getInstallDir() {
        return this.installDir;
    }

    public URI getWorkDir() {
        return this.workDir;
    }

    public URI getRootDir() {
        return this.rootDir;
    }

    public javax.jbi.component.Component getComponent() {
        return this.component;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("JBIComponent", Component.class, "JBIComponent");
        infoFactory.addAttribute("name", String.class, true);
        infoFactory.addAttribute("description", String.class, true);
        infoFactory.addAttribute("type", String.class, true);
        infoFactory.addAttribute("className", String.class, true);
        infoFactory.addReference("container", Container.class);
        infoFactory.addAttribute("configurationBaseUrl", URL.class, true);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.setConstructor(new String[]{"name", "description", "type", "className", "container", "configurationBaseUrl", "classLoader"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

