/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.geronimo;

import java.io.File;
import java.net.URI;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.servicemix.geronimo.Container;
import org.apache.servicemix.jbi.deployment.Descriptor;
import org.apache.servicemix.jbi.deployment.DescriptorFactory;

public class ServiceAssembly
implements GBeanLifecycle {
    private static final Log log = LogFactory.getLog(ServiceAssembly.class);
    private String name;
    private Container container;
    private URI rootDir;
    public static final GBeanInfo GBEAN_INFO;

    public ServiceAssembly(String name, Container container, URL configurationBaseUrl) throws Exception {
        this.name = name;
        this.container = container;
        this.rootDir = configurationBaseUrl.getProtocol().equalsIgnoreCase("file") ? new URI("file", configurationBaseUrl.getPath(), null) : URI.create(configurationBaseUrl.toString());
        log.info((Object)("Created JBI service assembly: " + name));
    }

    public void doStart() throws Exception {
        log.info((Object)("doStart called for JBI service assembly: " + this.name));
        this.container.register(this);
    }

    public void doStop() throws Exception {
        log.info((Object)("doStop called for JBI service assembly: " + this.name));
        this.container.unregister(this);
    }

    public void doFail() {
        log.info((Object)("doFail called for JBI service assembly: " + this.name));
    }

    public URI getRootDir() {
        return this.rootDir;
    }

    public String getName() {
        return this.name;
    }

    public Descriptor getDescriptor() throws Exception {
        return DescriptorFactory.buildDescriptor((File)new File(new File(this.rootDir), "install"));
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("JBIServiceAssembly", ServiceAssembly.class, "JBIServiceAssembly");
        infoFactory.addAttribute("name", String.class, true);
        infoFactory.addReference("container", Container.class);
        infoFactory.addAttribute("configurationBaseUrl", URL.class, true);
        infoFactory.setConstructor(new String[]{"name", "container", "configurationBaseUrl"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

