/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.geronimo;

import java.io.File;
import java.util.Collection;
import javax.jbi.JBIException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.servicemix.geronimo.Component;
import org.apache.servicemix.geronimo.Container;
import org.apache.servicemix.geronimo.ServiceAssembly;
import org.apache.servicemix.jbi.container.ComponentEnvironment;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.container.ServiceAssemblyEnvironment;
import org.apache.servicemix.jbi.framework.ComponentContextImpl;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.framework.ComponentNameSpace;
import org.apache.servicemix.jbi.framework.ServiceAssemblyLifeCycle;

public class ServiceMixGBean
implements GBeanLifecycle,
Container {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private JBIContainer container;
    private String name;
    private String directory;
    private TransactionManager transactionManager;
    private Kernel kernel;
    private Collection jndiResources;
    public static final GBeanInfo GBEAN_INFO;

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    public ServiceMixGBean(String name, String directory, TransactionManager transactionManager, Kernel kernel) {
        this.name = name;
        this.directory = directory;
        this.transactionManager = transactionManager;
        this.kernel = kernel;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ServiceMixGBean created");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ServiceMixGBean doStart");
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ServiceMixGBean.class.getClassLoader());
        try {
            if (this.container == null) {
                this.container = this.createContainer();
                this.container.init();
                this.container.start();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ServiceMixGBean doStop");
        }
        try {
            if (this.container != null) {
                this.container.shutDown();
            }
        }
        finally {
            this.container = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFail() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ServiceMixGBean doFail");
        }
        try {
            if (this.container != null) {
                try {
                    this.container.shutDown();
                }
                catch (JBIException e) {
                    this.log.info((Object)("Caught while closing due to failure: " + (Object)((Object)e)), (Throwable)e);
                }
            }
        }
        finally {
            this.container = null;
        }
    }

    private JBIContainer createContainer() {
        JBIContainer container = new JBIContainer();
        container.setName(this.name);
        container.setRootDir(this.directory);
        container.setTransactionManager((Object)this.transactionManager);
        container.setMonitorInstallationDirectory(false);
        container.setMonitorDeploymentDirectory(false);
        return container;
    }

    public void register(Component component) throws Exception {
        ComponentNameSpace cns = new ComponentNameSpace(this.container.getName(), component.getName());
        ComponentContextImpl context = new ComponentContextImpl(this.container, cns);
        ComponentEnvironment env = new ComponentEnvironment();
        env.setComponentRoot(new File(component.getRootDir()));
        env.setInstallRoot(new File(component.getInstallDir()));
        env.setWorkspaceRoot(new File(component.getWorkDir()));
        context.setEnvironment(env);
        this.container.activateComponent(null, component.getComponent(), component.getDescription(), context, component.getType().equals("binding-component"), component.getType().equals("service-engine"), null);
        ComponentMBeanImpl cmb = this.container.getComponent(component.getName());
        File stateFile = cmb.getContext().getEnvironment().getStateFile();
        if (stateFile.isFile()) {
            cmb.setInitialRunningState();
        } else {
            cmb.start();
        }
    }

    public void unregister(Component component) throws Exception {
        this.container.deactivateComponent(component.getName());
    }

    public void register(ServiceAssembly assembly) throws Exception {
        File rootDir = new File(assembly.getRootDir());
        ServiceAssemblyEnvironment env = new ServiceAssemblyEnvironment();
        env.setRootDir(rootDir);
        env.setInstallDir(new File(rootDir, "install"));
        env.setSusDir(new File(rootDir, "sus"));
        env.setStateFile(new File(rootDir, "state.xml"));
        ServiceAssemblyLifeCycle salc = this.container.getRegistry().registerServiceAssembly(assembly.getDescriptor().getServiceAssembly(), env);
        if (env.getStateFile().isFile()) {
            salc.restore();
        } else {
            salc.start();
        }
    }

    public void unregister(ServiceAssembly assembly) throws Exception {
        ServiceAssemblyLifeCycle salc = this.container.getRegistry().getServiceAssembly(assembly.getName());
        salc.shutDown(false);
        this.container.getRegistry().unregisterServiceAssembly(assembly.getName());
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("ServiceMix JBI Container", ServiceMixGBean.class, "JBIContainer");
        infoFactory.addInterface(Container.class);
        infoFactory.addAttribute("name", String.class, true);
        infoFactory.addAttribute("directory", String.class, true);
        infoFactory.addReference("transactionManager", TransactionManager.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.setConstructor(new String[]{"name", "directory", "transactionManager", "kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

