/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.core.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.servicemix.nmr.api.security.AuthorizationEntry;
import org.apache.servicemix.nmr.api.security.AuthorizationService;
import org.apache.servicemix.nmr.api.security.GroupPrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAuthorizationService
implements AuthorizationService {
    private List<AuthorizationEntry> authorizationEntries = new ArrayList<AuthorizationEntry>();
    private Comparator<AuthorizationEntry> comparator = new Comparator<AuthorizationEntry>(){

        @Override
        public int compare(AuthorizationEntry o1, AuthorizationEntry o2) {
            if (o1.getRank() < o2.getRank()) {
                return -1;
            }
            if (o1.getRank() > o2.getRank()) {
                return 1;
            }
            return 0;
        }
    };

    public void register(AuthorizationEntry entry, Map<String, ?> props) {
        this.authorizationEntries.add(entry);
        Collections.sort(this.authorizationEntries, this.comparator);
    }

    public void unregister(AuthorizationEntry entry, Map<String, ?> props) {
        this.authorizationEntries.remove(entry);
        Collections.sort(this.authorizationEntries, this.comparator);
    }

    public Set<GroupPrincipal> getAcls(String endpoint, QName operation) {
        HashSet<GroupPrincipal> acls = new HashSet<GroupPrincipal>();
        for (AuthorizationEntry entry : this.authorizationEntries) {
            if (!this.match(entry, endpoint, operation)) continue;
            if (AuthorizationEntry.Type.Add == entry.getType()) {
                acls.addAll(entry.getAcls());
                continue;
            }
            if (AuthorizationEntry.Type.Set == entry.getType()) {
                acls.clear();
                acls.addAll(entry.getAcls());
                continue;
            }
            if (AuthorizationEntry.Type.Remove != entry.getType()) continue;
            acls.removeAll(entry.getAcls());
        }
        return acls;
    }

    protected boolean match(AuthorizationEntry entry, String endpoint, QName operation) {
        return this.match(entry.getEndpoint(), endpoint) && (entry.getOperation() == null || operation == null || this.match(entry.getOperation(), operation));
    }

    private boolean match(QName acl, QName target) {
        return this.match(acl.getNamespaceURI(), target.getNamespaceURI()) && this.match(acl.getLocalPart(), target.getLocalPart());
    }

    private boolean match(String acl, String target) {
        return acl == null || acl.equals("*") || Pattern.matches(acl, target);
    }
}

