/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.specs.locator;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.servicemix.specs.locator.OsgiLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class Activator
implements BundleActivator,
SynchronousBundleListener {
    private BundleContext bundleContext;
    private ConcurrentMap<Long, Map<String, Callable<Class>>> factories = new ConcurrentHashMap<Long, Map<String, Callable<Class>>>();

    public synchronized void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        bundleContext.addBundleListener((BundleListener)this);
        for (Bundle bundle : bundleContext.getBundles()) {
            this.register(bundle);
        }
    }

    public synchronized void stop(BundleContext bundleContext) throws Exception {
        while (!this.factories.isEmpty()) {
            this.unregister(bundleContext.getBundle(((Long)this.factories.keySet().iterator().next()).longValue()));
        }
        this.bundleContext = null;
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 32) {
            this.register(event.getBundle());
        } else if (event.getType() == 64) {
            this.unregister(event.getBundle());
        }
    }

    protected void register(final Bundle bundle) {
        HashMap<String, 1> map = (HashMap<String, 1>)this.factories.get(bundle.getBundleId());
        Enumeration e = bundle.findEntries("META-INF/services/", "*", false);
        if (e != null) {
            while (e.hasMoreElements()) {
                final URL u = (URL)e.nextElement();
                String url = u.toString();
                if (url.endsWith("/")) continue;
                String factoryId = url.substring(url.lastIndexOf("/") + 1);
                if (map == null) {
                    map = new HashMap<String, 1>();
                    this.factories.put(bundle.getBundleId(), map);
                }
                map.put(factoryId, new Callable<Class>(){

                    @Override
                    public Class call() throws Exception {
                        BufferedReader br = new BufferedReader(new InputStreamReader(u.openStream(), "UTF-8"));
                        String factoryClassName = br.readLine();
                        br.close();
                        return bundle.loadClass(factoryClassName);
                    }
                });
            }
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                OsgiLocator.register((String)entry.getKey(), (Callable)entry.getValue());
            }
        }
    }

    protected void unregister(Bundle bundle) {
        Map map = (Map)this.factories.remove(bundle.getBundleId());
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                OsgiLocator.unregister((String)entry.getKey(), (Callable)entry.getValue());
            }
        }
    }
}

