/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.runtime.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.MBeanNames;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.runtime.ComponentWrapper;
import org.apache.servicemix.jbi.runtime.impl.ComponentRegistryImpl;
import org.apache.servicemix.jbi.runtime.impl.EndpointImpl;
import org.apache.servicemix.jbi.runtime.impl.utils.DOMUtil;
import org.apache.servicemix.jbi.runtime.impl.utils.URIResolver;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.NMR;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponentContext
implements ComponentContext,
MBeanNames {
    public static final String JBI_NAMESPACE = "http://java.sun.com/jbi/end-point-reference";
    public static final String JBI_PREFIX = "jbi:";
    public static final String JBI_ENDPOINT_REFERENCE = "end-point-reference";
    public static final String JBI_SERVICE_NAME = "service-name";
    public static final String JBI_ENDPOINT_NAME = "end-point-name";
    public static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    private static final Log LOG = LogFactory.getLog(AbstractComponentContext.class);
    protected DeliveryChannel dc;
    protected ComponentRegistryImpl componentRegistry;

    public AbstractComponentContext(ComponentRegistryImpl componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    public NMR getNmr() {
        return this.componentRegistry.getNmr();
    }

    public ServiceEndpoint getEndpoint(QName serviceName, String endpointName) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("SERVICE_NAME", serviceName);
        props.put("ENDPOINT_NAME", endpointName);
        List endpoints = this.getNmr().getEndpointRegistry().query(props);
        if (endpoints.isEmpty()) {
            return null;
        }
        Map p = this.getNmr().getEndpointRegistry().getProperties(endpoints.get(0));
        return new SimpleServiceEndpoint(p);
    }

    public Document getEndpointDescriptor(ServiceEndpoint endpoint) throws JBIException {
        block5: {
            Map<String, ?> props;
            String url;
            if (endpoint instanceof SimpleServiceEndpoint && (url = (String)(props = ((SimpleServiceEndpoint)endpoint).getProperties()).get("WSDL_URL")) != null) {
                InputStream is = null;
                try {
                    is = new URL(url).openStream();
                    return DOMUtil.parseDocument(is);
                }
                catch (Exception e) {
                    if (is == null) break block5;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    public ServiceEndpoint[] getEndpoints(QName interfaceName) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("INTERFACE_NAME", interfaceName);
        return this.internalQueryEndpoints(props);
    }

    protected SimpleServiceEndpoint[] internalQueryEndpoints(Map<String, Object> props) {
        List endpoints = this.getNmr().getEndpointRegistry().query(props);
        ArrayList<SimpleServiceEndpoint> ses = new ArrayList<SimpleServiceEndpoint>();
        for (Endpoint endpoint : endpoints) {
            Map epProps = this.getNmr().getEndpointRegistry().getProperties((Object)endpoint);
            QName serviceName = (QName)epProps.get("SERVICE_NAME");
            String endpointName = (String)epProps.get("ENDPOINT_NAME");
            if (serviceName == null || endpointName == null) continue;
            ses.add(new SimpleServiceEndpoint(epProps));
        }
        return ses.toArray(new SimpleServiceEndpoint[ses.size()]);
    }

    public ServiceEndpoint[] getEndpointsForService(QName serviceName) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("SERVICE_NAME", serviceName);
        return this.internalQueryEndpoints(props);
    }

    public ServiceEndpoint[] getExternalEndpoints(QName interfaceName) {
        return new ServiceEndpoint[0];
    }

    public ServiceEndpoint[] getExternalEndpointsForService(QName serviceName) {
        return new ServiceEndpoint[0];
    }

    public DeliveryChannel getDeliveryChannel() throws MessagingException {
        return this.dc;
    }

    public Logger getLogger(String suffix, String resourceBundleName) throws MissingResourceException, JBIException {
        try {
            String name = suffix != null ? this.getComponentName() + suffix : this.getComponentName();
            return Logger.getLogger(name, resourceBundleName);
        }
        catch (IllegalArgumentException e) {
            throw new JBIException("A logger can not be created using resource bundle " + resourceBundleName);
        }
    }

    public MBeanNames getMBeanNames() {
        return this;
    }

    public MBeanServer getMBeanServer() {
        if (this.componentRegistry.getEnvironment() != null) {
            return this.componentRegistry.getEnvironment().getMBeanServer();
        }
        return null;
    }

    public InitialContext getNamingContext() {
        if (this.componentRegistry.getEnvironment() != null) {
            return this.componentRegistry.getEnvironment().getNamingContext();
        }
        return null;
    }

    public Object getTransactionManager() {
        if (this.componentRegistry.getEnvironment() != null) {
            return this.componentRegistry.getEnvironment().getTransactionManager();
        }
        return null;
    }

    public ObjectName createCustomComponentMBeanName(String customName) {
        if (this.componentRegistry.getManagementContext() != null) {
            return this.componentRegistry.getManagementContext().createCustomComponentMBeanName(customName, this.getComponentName());
        }
        return null;
    }

    public String getJmxDomainName() {
        if (this.componentRegistry.getManagementContext() != null) {
            return this.componentRegistry.getManagementContext().getJmxDomainName();
        }
        return null;
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) {
        for (ComponentWrapper component : this.componentRegistry.getServices()) {
            ServiceEndpoint se = component.getComponent().resolveEndpointReference(epr);
            if (se == null) continue;
            return se;
        }
        ServiceEndpoint se = this.resolveInternalEPR(epr);
        if (se != null) {
            return se;
        }
        return this.resolveStandardEPR(epr);
    }

    public ServiceEndpoint resolveInternalEPR(DocumentFragment epr) {
        if (epr == null) {
            throw new NullPointerException("resolveInternalEPR(epr) called with null epr.");
        }
        NodeList nl = epr.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element el;
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || (el = (Element)n).getNamespaceURI() == null || !el.getNamespaceURI().equals(JBI_NAMESPACE) || el.getLocalName() == null || !el.getLocalName().equals(JBI_ENDPOINT_REFERENCE)) continue;
            String serviceName = el.getAttributeNS(el.getNamespaceURI(), JBI_SERVICE_NAME);
            QName serviceQName = DOMUtil.createQName(el, serviceName);
            String endpointName = el.getAttributeNS(el.getNamespaceURI(), JBI_ENDPOINT_NAME);
            return this.getEndpoint(serviceQName, endpointName);
        }
        return null;
    }

    public ServiceEndpoint resolveStandardEPR(DocumentFragment epr) {
        try {
            NodeList children = epr.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Element address;
                String uri;
                Node n = children.item(i);
                if (n.getNodeType() != 1) continue;
                Element elem = (Element)n;
                String[] namespaces = new String[]{"http://www.w3.org/2005/08/addressing", "http://schemas.xmlsoap.org/ws/2004/08/addressing", "http://schemas.xmlsoap.org/ws/2004/03/addressing", "http://schemas.xmlsoap.org/ws/2003/03/addressing"};
                NodeList nl = null;
                for (String ns : namespaces) {
                    NodeList tnl = elem.getElementsByTagNameNS(ns, "Address");
                    if (tnl.getLength() != 1) continue;
                    nl = tnl;
                    break;
                }
                if (nl == null || (uri = DOMUtil.getElementText(address = (Element)nl.item(0))) == null) continue;
                if ((uri = uri.trim()).startsWith("endpoint:")) {
                    uri = uri.substring("endpoint:".length());
                    String[] parts = URIResolver.split3(uri);
                    return this.getEndpoint(new QName(parts[0], parts[1]), parts[2]);
                }
                if (!uri.startsWith("service:")) continue;
                uri = uri.substring("service:".length());
                String[] parts = URIResolver.split2(uri);
                return this.getEndpoint(new QName(parts[0], parts[1]), parts[1]);
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Unable to resolve EPR: " + e));
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SimpleServiceEndpoint
    implements ServiceEndpoint {
        private Map<String, ?> properties;
        private EndpointImpl endpoint;

        public SimpleServiceEndpoint(Map<String, ?> properties) {
            this.properties = properties;
        }

        public SimpleServiceEndpoint(Map<String, ?> properties, EndpointImpl endpoint) {
            this.properties = properties;
            this.endpoint = endpoint;
        }

        public Map<String, ?> getProperties() {
            return this.properties;
        }

        public EndpointImpl getEndpoint() {
            return this.endpoint;
        }

        public DocumentFragment getAsReference(QName operationName) {
            try {
                Document doc = DOMUtil.newDocument();
                DocumentFragment fragment = doc.createDocumentFragment();
                Element epr = doc.createElementNS(AbstractComponentContext.JBI_NAMESPACE, "jbi:end-point-reference");
                epr.setAttributeNS(AbstractComponentContext.XMLNS_NAMESPACE, "xmlns:sns", this.endpoint.getServiceName().getNamespaceURI());
                epr.setAttributeNS(AbstractComponentContext.JBI_NAMESPACE, "jbi:service-name", "sns:" + this.endpoint.getServiceName().getLocalPart());
                epr.setAttributeNS(AbstractComponentContext.JBI_NAMESPACE, "jbi:end-point-name", this.endpoint.getEndpointName());
                fragment.appendChild(epr);
                return fragment;
            }
            catch (Exception e) {
                LOG.warn((Object)("Unable to create reference for ServiceEndpoint " + this.endpoint), (Throwable)e);
                return null;
            }
        }

        public String getEndpointName() {
            return (String)this.properties.get("ENDPOINT_NAME");
        }

        public QName[] getInterfaces() {
            QName[] qNameArray;
            QName itf = (QName)this.properties.get("INTERFACE_NAME");
            if (itf != null) {
                QName[] qNameArray2 = new QName[1];
                qNameArray = qNameArray2;
                qNameArray2[0] = itf;
            } else {
                qNameArray = new QName[]{};
            }
            return qNameArray;
        }

        public QName getServiceName() {
            return (QName)this.properties.get("SERVICE_NAME");
        }
    }
}

