/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.impl;

import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.context.BundleContextAware;

public abstract class AbstractBundleWatcher
implements BundleContextAware,
InitializingBean,
DisposableBean {
    private BundleContext bundleContext;
    private SynchronousBundleListener bundleListener;
    private List<Bundle> bundles = new ArrayList<Bundle>();

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.bundleListener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                switch (event.getType()) {
                    case 2: {
                        AbstractBundleWatcher.this.onBundleStarted(event.getBundle());
                        break;
                    }
                    case 4: {
                        AbstractBundleWatcher.this.onBundleStopped(event.getBundle());
                    }
                }
            }
        };
        this.bundleContext.addBundleListener((BundleListener)this.bundleListener);
        Bundle[] bundles = this.bundleContext.getBundles();
        if (bundles != null) {
            for (Bundle bundle : bundles) {
                if (bundle.getState() != 32) continue;
                this.onBundleStarted(bundle);
            }
        }
    }

    public void destroy() throws Exception {
        this.bundleContext.removeBundleListener((BundleListener)this.bundleListener);
        for (Bundle bundle : this.bundles.toArray(new Bundle[this.bundles.size()])) {
            this.onBundleStopped(bundle);
        }
    }

    private void onBundleStarted(Bundle bundle) {
        if (this.match(bundle) && !this.bundles.contains(bundle)) {
            this.register(bundle);
            this.bundles.add(bundle);
        }
    }

    private void onBundleStopped(Bundle bundle) {
        if (this.bundles.remove(bundle)) {
            this.unregister(bundle);
        }
    }

    protected boolean match(Bundle bundle) {
        return true;
    }

    protected abstract void register(Bundle var1);

    protected abstract void unregister(Bundle var1);
}

